package io.geekidea.springbootplus.test;

import cn.hutool.core.lang.Snowflake;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.ws.utils.KeyGenerator;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.Date;

/**
 * 生成测试appkey与appSecret对,并存入数据库
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class ImApplicationTest {

    @Autowired
    private ImConversationMembersService imConversationMembersService;

    @Autowired
    private ImApplicationService imApplicationService;

    public static void main(String[] args) {
        String appKey = KeyGenerator.getRandomString();  //定义变量接收
        String appSecret = KeyGenerator.getAppSecret();

        int i = 1;
        System.out.println(appKey);
        System.out.println(appSecret);
    }

    @Test
    public void add() {
        for (int i = 0; i < 10; i++) {
            addDb(i);
        }
    }

    private void addDb( int i) {
        // 生成AppKey
        String appKey = KeyGenerator.getRandomString();  //定义变量接收

        // 生成appSecret
        String appSecret = KeyGenerator.getAppSecret();

        ImApplication imApplication = new ImApplication();
        imApplication.setCreateTime(new Date());
        imApplication.setUpdateTime(new Date());
        imApplication.setId(new Snowflake(1L, 1L).nextId());
        imApplication.setAppKey(appKey);
        imApplication.setAppSecret(appSecret);
        imApplication.setAppName("test" + i);

        imApplicationService.save(imApplication);
    }

}
