package com.wecloud.im.appmanager;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.imserver.client.api.ImApplicationFacade;
import com.wecloud.imserver.client.model.ao.CreateApplicationAO;
import com.wecloud.imserver.client.model.ao.UpdateAppSecretAO;
import com.wecloud.imserver.client.model.dto.Result;
import com.wecloud.imserver.client.model.dto.UpdateAppSecretDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author nanqianhao
 * @date 2022/5/26
 * @apiNote
 */
@Slf4j
@Service
@DubboService
public class ImApplicationFacadeImpl implements ImApplicationFacade {

    @Autowired
    private ImApplicationService imApplicationService;



    @Override
    public Result<Boolean> updateAppSecret(UpdateAppSecretAO updateSecretAO) {
        log.info("更新Secret传入参数为{}",updateSecretAO);
        ImApplication application = imApplicationService.getOne(new LambdaQueryWrapper<ImApplication>().eq(ImApplication::getId, updateSecretAO.getId()).eq(ImApplication::getAppKey,updateSecretAO.getAppKey()));
        UpdateAppSecretDTO updateAppSecretDTO = new UpdateAppSecretDTO();
        updateAppSecretDTO.setId(updateSecretAO.getId());
        updateAppSecretDTO.setAppKey(updateSecretAO.getAppKey());
        updateAppSecretDTO.setNewAppSecret(updateSecretAO.getAppSecret());
        application.setAppSecret(updateSecretAO.getAppSecret());
        application.setUpdateTime(new Date());
        boolean result = imApplicationService.updateById(application);
        log.info("更新Secret返回结果为{}",updateAppSecretDTO);
        return Result.getSuccessResult(result);
    }

    @Override
    public Result<Boolean> createApplication(CreateApplicationAO createApplicationAO) {
        log.info("创建应用传入的参数为{}",createApplicationAO);
        ImApplication imApplication = new ImApplication();
        if (createApplicationAO.getOwnerId()==null||"".equals(createApplicationAO.getOwnerId())){
            return Result.getBusinessException("请传入使用用户id", null);
        }
        if (createApplicationAO.getId()==null){
            return Result.getBusinessException("请传入新增应用id", null);
        }
        imApplication.setId(createApplicationAO.getId());
        imApplication.setAppName(createApplicationAO.getAppName());
        imApplication.setAppKey(createApplicationAO.getAppKey());
        imApplication.setAppSecret(createApplicationAO.getAppSecret());
        imApplication.setOwnerId(createApplicationAO.getOwnerId());
        imApplication.setCompanyId(createApplicationAO.getCompanyId());
        imApplication.setStatus(1);
        imApplication.setCreateTime(new Date());
        log.info("新建的应用信息为{}",imApplication);
        boolean saveResult = imApplicationService.save(imApplication);
        return Result.getSuccessResult(saveResult);
    }


    @Override
    public Result<Boolean> updateApplication(CreateApplicationAO createApplicationAO) {
        log.info("编辑应用传入参数为{}",createApplicationAO);
        ImApplication application = imApplicationService.getOne(new LambdaQueryWrapper<ImApplication>().eq(ImApplication::getId, createApplicationAO.getId()));
        application.setAppName(createApplicationAO.getAppName());
        application.setUpdateTime(new Date());
        boolean updateResult = imApplicationService.updateById(application);
        log.info("编辑的应用信息为{}",application);
        return Result.getSuccessResult(updateResult);
    }

    @Override
    public Result<Boolean> deleteApplication(Long applicationId) {
        log.info("删除应用传入应用id参数为{}",applicationId);
        ImApplication application = imApplicationService.getOne(new LambdaQueryWrapper<ImApplication>().eq(ImApplication::getId, applicationId));
        application.setStatus(3);
        application.setUpdateTime(new Date());
        log.info("删除应用信息为{}",application);
        boolean deleteResult = imApplicationService.updateById(application);
        return Result.getSuccessResult(deleteResult);
    }
}
