package com.library.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

import com.google.gson.Gson;

public class GetCityCon {

	public static SAXBuilder builder=null;
	public static Document document=null;
	public static Element root=null;
	
	static{
//		File file = new File("C:\\Users\\Administrator\\Desktop\\LocList.xml");
		
		String path=GetCityCon.class.getResource("/").toString();
		path=path.substring(6, path.length()-1);
		path= URLDecoder.decode(path);
		File file = new File(path+"/Com/FS/Util/LocList.xml");
		builder = new SAXBuilder();
		try {
			document = builder.build(file);
			root = document.getRootElement();
		} catch (JDOMException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	
	public static void main(String[] args) {
		System.out.println(new Gson().toJson(getAllCountry()));
		System.out.println(new Gson().toJson(getProvice("中国")));
		System.out.println(new Gson().toJson(getCity("中国", "广东")));
		System.out.println(new Gson().toJson(getAddress("中国", "广东", "东莞")));
	}
	
	/**
	 * 获得城市的区
	 */
	public static List<String> getAddress(String CountryName,String ProviceName,String CityName){
		List<String> list=new ArrayList<String>();
		// 枚举所有子节点 
		for (Iterator i = root.getChildren().iterator(); i.hasNext(); ) { 
			Element el = (Element)i.next();
			String name=el.getAttributeValue("Name");
			if(name.equals(CountryName)){
				for (Iterator j = el.getChildren().iterator(); j.hasNext();) {
					Element element2 = (Element)j.next();
					name=element2.getAttributeValue("Name");
					if(name.equals(ProviceName)){
						for (Iterator k = element2.getChildren().iterator(); k.hasNext();) {
							Element element3 = (Element)k.next();
							name=element3.getAttributeValue("Name");
							if(name.equals(CityName)){
								for (Iterator l = element3.getChildren().iterator(); l.hasNext();) {
									Element element4 = (Element)l.next();
									name=element4.getAttributeValue("Name");
									list.add(name);
								}
								break;
							}
						}
						break;
					}
				}
				break;
			}
		}
		return list;
	}
	
	
	/**
	 * 获得一个省份的所有城市
	 */
		public static List<String> getCity(String CountryName,String ProviceName){
			List<String> list=new ArrayList<String>();
			// 枚举所有子节点 
			for (Iterator i = root.getChildren().iterator(); i.hasNext(); ) { 
				Element el = (Element)i.next();
				String name=el.getAttributeValue("Name");
				if(name.equals(CountryName)){
					for (Iterator j = el.getChildren().iterator(); j.hasNext();) {
						Element element2 = (Element)j.next();
						name=element2.getAttributeValue("Name");
						if(name.equals(ProviceName)){
							for (Iterator k = element2.getChildren().iterator(); k.hasNext();) {
								Element element3 = (Element)k.next();
								name=element3.getAttributeValue("Name");
								list.add(name);
							}
							break;
						}
					}
					break;
				}
			}
			return list;
		}
	
	
	
	/**
	 * 获得某一个国家的所有省份
	 * @param CountryName
	 * @return
	 */
	public static List<String> getProvice(String CountryName){
		List<String> list=new ArrayList<String>();
		// 枚举所有子节点 
		for (Iterator i = root.getChildren().iterator(); i.hasNext(); ) { 
			Element el = (Element)i.next();
			String name=el.getAttributeValue("Name");
			if(name.equals(CountryName)){
				for (Iterator j = el.getChildren().iterator(); j.hasNext();) {
					Element element2 = (Element)j.next();
					name=element2.getAttributeValue("Name");
					list.add(name);
				}
				break;
			}
		}
		return list;
	}
	
	
	
	/**
	 * 获得所有国家
	 * @return
	 */
	public static List<String> getAllCountry() {
		List<String> list = new ArrayList<String>();
		// 枚举所有子节点
		for (Iterator i = root.getChildren().iterator(); i.hasNext();) {
			Element element = (Element) i.next();
			String name = element.getAttributeValue("Name");
			list.add(name);
		}
		return list;
	}

}
