package com.library.service;

import com.library.model.AutomaticQueueModel;

import java.math.BigDecimal;

/**
 * Created by Administrator on 2018\11\22 0022.
 */
public interface AutomaticCodeService {
    /***
     *
     * Description:判断是否是中国手机号
     * @author feng
     * @date 2017年8月28日 下午1:38:49
     * @version 1.0
     * @param phone
     * @return
     */
    public boolean isChinaPhone(String phone);

    /***
     *
     * Description:定时器调用，手机话费自动充值处理
     * @author feng
     * @date 2017年8月28日 上午10:51:35
     * @version 1.0
     */
    public void automaticForTack();
    /***
     *
     * Description:处理后返回的结果
     * @author feng
     * @date 2017年8月28日 上午10:53:12
     * @version 1.0
     * @param early 操作的列表数据
     * @param success 成功=true,失败=false
     * @param desc 描述 （失败的订单要描述失败的原因）
     */
    public void automaticForTackResult(AutomaticQueueModel early, boolean success, String desc,String top_up_num);
    /***
     *
     * Description:人工转自动处理
     * @author feng
     * @date 2017年8月28日 下午3:38:43
     * @version 1.0
     * @param autoId 后台状态id
     * @param phone 手机号
     * @param money 金额
     * @return
     */
    public int  artificialToAutomatic(Integer autoId, String phone, BigDecimal money);
}
