package com.library.respcode;
/**
 * Created by geely
 */
public enum ResponseCode {

    SUCCESS(1,"SUCCESS"),//成功
    ERROR(-1,"服务器响应失败"),//失败，错误
    NEED_LOGIN(2001,"需要登录"),//没有登录
    No_Permissions(2002,"没权限"),//没权限
    ILLEGAL_ARGUMENT(2003,"不合法参数"),//参数不正确
    BUY_SUCCESS(2004,"商品购买成功"),//商品购买成功（价格为零时）
    RepeatParticipationPlan(2005,"您已参与该商品的夺宝计划，请不要重复操作"),//重复参与计划
    pleaseFillInTheNicknameOfVpay(2006,"个人信息中，请填写vpay的昵称"),//无vpay昵称
    ExistingAddress(2007,"已存在地址，不可再添加"),//现在做成只能有一个收货地址
    InsufficientBalance(2008,"余额不足"),//余额不足
    MorePurchasesThanTheRest(2009,"本次购买的次数不能大于剩余次数");//购买次数多过剩余的

    private final int code;
    private final String desc;


    ResponseCode(int code,String desc){
        this.code = code;
        this.desc = desc;
    }

    public int getCode(){
        return code;
    }
    public String getDesc(){
        return desc;
    }

}
