package com.library.controller;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.library.TopUp.Http.HttpUtils;
import com.library.TopUp.Statel.HttpClientUtils;
import com.library.TopUp.Statel.SeatelSentUtils;
import com.library.TopUp.cellcard.CellcardSentUtils;
import com.library.TopUp.mefont.MetfoneSentUtils;
import com.library.TopUp.model.ResultsModel;
import com.library.respcode.ServerResponse;
import com.library.service.AdminService;
import com.library.service.CommService;
import com.library.util.QiniuUtils;
import com.wechat.pay.MD5Util;
import org.apache.http.util.TextUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/*
 *  @项目名：  yunVpay
 *  @包名：    com.library.controller
 *  @文件名:   CommonController
 *  @创建者:   zhouzhuo
 *  @创建时间:  2018/11/1 14:50
 *  @描述：    TODO
 */
@Controller
@RequestMapping("/Common")
public class CommonController {

    @Resource
    private CommService commService;

    @Resource
    private HttpServletRequest request;

    //查询剩余的余额
    @ResponseBody
    @RequestMapping("checkMyMoney")
    private ServerResponse checkMyMoney() {
        return commService.checkMyMoney();
    }

    //保存邮箱
    @ResponseBody
    @RequestMapping("saveTheEmail")
    private ServerResponse saveTheEmail() {
        return commService.saveTheEmail();
    }


    //检查Seatel运营商的手机
    @ResponseBody
    @RequestMapping("checkPhoneInSeatel")
    private ServerResponse checkPhoneInSeatel() {
        return commService.checkPhoneInSeatel();
    }

    //查询Metfone手机号剩余的余额
    @ResponseBody
    @RequestMapping("checkMyMoneyInMetfone")
    private ServerResponse checkMyMoneyInMetfone() {
        return commService.checkMyMoneyInMetfone();
    }

    //查询Seatel运营商剩余的余额
    @ResponseBody
    @RequestMapping("queryAgentFeeInSeatel")
    private ServerResponse queryAgentFeeInSeatel() {
        return commService.queryAgentFeeInSeatel();
    }

    //    查询Cellcard运营商剩余的余额
    @ResponseBody
    @RequestMapping("queryAgentFeeInCellcard")
    private ServerResponse queryAgentFeeInCellcard() {
        return commService.queryAgentFeeInCellcard();
    }


}
