package com.library.config;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.library.bean.PowerBean;
import com.library.model.AdminModel;
import com.library.util.Tools;

/*
 * 权限配置
 */
public class PowerConfig {
	
	public static Integer ProductManage=1001;//产品管理
	public static Integer ProjectManage=1002;//项目管理
	public static Integer MemberManager=1003;//会员管理
	public static Integer OrderManager=1004;//订单管理
	public static Integer SystemSetting=1005;//系统设置
	
	public static List<PowerBean> powerBeans;//权限集合
	
	/**
	 * 获取权限集合
	 */
	public static List<PowerBean> getPowerList(){
		if(powerBeans==null){
			powerBeans = new ArrayList<PowerBean>();
			powerBeans.add(new PowerBean("产品管理", ProductManage));
			powerBeans.add(new PowerBean("项目管理", ProjectManage));
			powerBeans.add(new PowerBean("会员管理", MemberManager));
			powerBeans.add(new PowerBean("订单管理", OrderManager));
			powerBeans.add(new PowerBean("系统设置", SystemSetting));
		}
		return powerBeans;
	}
	
	/**
	 * 判断是否拥有该权限
	 * 参数：请求头对象，权限代号
	 * ture 有,false没有
	 */
	public static boolean isHasPower(HttpServletRequest request, Integer Code){
		AdminModel adminModel =(AdminModel) request.getSession().getAttribute(NameValue.Admin_Session);
		
		if(Code==-1){
			return false;
		}
		
		if(adminModel==null){
			return false;
		}
		if(adminModel.getAdmin_type()==1){//超级管理员，直接过
			return true;
		}
		List<Integer> list = Tools.gson.fromJson(adminModel.getJurisdiction(), Tools.IntegerListType);
		if(list==null){
			return false;
		}
		for(Integer value :list){
			if(value.equals(Code)){//有该权限
				return true;
			}
		}
		
		return false;
	}
	
	/**
	 * 判断是否超级管理员
	 */
	public static boolean isSuperAdmin(HttpServletRequest request){
		AdminModel adminModel =(AdminModel) request.getSession().getAttribute(NameValue.Admin_Session);
		if(adminModel!=null && adminModel.getAdmin_type()==1){
			return true;
		}
		return false;
	}
}
