var id; //商品ID

var toast = new auiToast();

/**
 * 根据ID获取商品信息
 */
function getData() {
  toast.loading({
    title: "加载中",
    duration: 2000
  });
  _vp.productDetail(
    {
      p_id: id
    },
    function(res) {
      toast.hide();
      if (res.status == 2001) {
        //需要登录
        top.location.href = "login.html";
        return;
      } else if (res.status == -1) {
        toast.fail({
          title: "系统繁忙",
          duration: 2000
        });
        return;
      }
      $(".commdity-name").text(res.data.product_name);
      $('.singleprice').text(res.data.price);
      /*$(".cp_mian h2").text(res.data.product_name);*/
      $(".f_bt").text(res.data.product_subheading);
      $(".one").text("期号：" + res.data.issue);
      $(".two").text(
        "总需：" +
          res.data.need_number +
          "人次（本期参与" +
          res.data.participate_number +
          "人）"
      );
      $("#topImg").attr("src", res.data.product_image);
      console.log(res.data)
      console.log(res.data.finish_time !=null)
      if ( res.data.finish_time !=null){
          addTimer("timer", res.data.finish_time);
      }else {
    	  $("#timer").hide();
          /*$("#timer").text("");*/
      }

    }
  );
}

$(function() {
  id = GetQueryString("id");
  getData();
});

var addTimer = (function() {
  var list = [],
    interval;

  return function(id, timeStamp) {
    if (!interval) {
      interval = setInterval(go, 1);
    }
    list.push({ ele: document.getElementById(id), time: timeStamp });
  };

  function go() {
    for (var i = 0; i < list.length; i++) {
      list[i].ele.innerHTML = changeTimeStamp(list[i].time);
      if (!list[i].time) list.splice(i--, 1);
    }
  }

  //传入unix时间戳，得到倒计时
  function changeTimeStamp(timeStamp) {
    var distancetime = timeStamp - new Date().getTime();
    if (distancetime > 0) {
      //如果大于0.说明尚未到达截止时间
      var ms = Math.floor(distancetime % 1000);
      var sec = Math.floor((distancetime / 1000) % 60);
      var min = Math.floor((distancetime / 1000 / 60) % 60);
      var hour = Math.floor((distancetime / 1000 / 60 / 60) % 24);

      if (ms < 100) {
        ms = "0" + ms;
      }
      if (sec < 10) {
        sec = "0" + sec;
      }
      if (min < 10) {
        min = "0" + min;
      }
      if (hour < 10) {
        hour = "0" + hour;
      }
      var html =
        "<label>开奖倒计时：</label><span>" +
        hour +
        "</span><em>:</em><span>" +
        min +
        "</span><em>:</em><span>" +
        sec +
        "</span>";
      // return hour + ":" +min + ":" +sec ;
      return html;
    } else {
      //若否，就是已经到截止时间了
      return;
    }
  }
})();
