<%@ page import="com.library.util.Tools" %>
<%@ page import="com.library.bean.PowerBean" %>
<%@ page language="java" import="java.util.*,com.library.config.*" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ page import="com.library.model.AdminModel" %>

<!doctype html>
<html lang="cn">
<head>
    <meta charset="UTF-8">
    <title>Vpay云购系统登录</title>
    <meta name="renderer" content="webkit|ie-comp|ie-stand">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width,user-scalable=yes, minimum-scale=0.4, initial-scale=0.8,target-densitydpi=low-dpi"/>
    <meta http-equiv="Cache-Control" content="no-siteapp"/>

    <link rel="shortcut icon" href="favicon.ico"/>
    <link rel="stylesheet" href="./css/font.css">
    <link rel="stylesheet" href="./css/xadmin.css">
    <script type="text/javascript" src="js/jquery-2.1.1.min.js"></script>
    <script src="./lib/layui/layui.js" charset="utf-8"></script>
    <script type="text/javascript" src="./js/xadmin.js"></script>

    <script type="text/javascript">
        $(function () {
            setTimeout(function () {
                getAdmin();
            }, 400);//延迟等所有元素加载完成
        });


        //获取管理员账户信息
        function getAdmin() {
            $.ajax({
                type: "post",
                url: "../../AdminManage/adminOpear",
                data: "type=3",
                success: function (data) {
                    console.log(data);
                    if (data.status == 2001) {//需要登录
                        top.location.href = "../admin/";
                        return;
                    } else if (data.status == 1) {//响应成功
                        var state = data.data.admin_type == 1 ? "【超级管理员】" : "【普通管理员】";
                        $("#username").html(data.data.admin_name + state);
                        //$("#title").html(data.data.username);
                        $("#tabTitle").html(data.data.admin_name + state);
                    } else {
                        layer.msg(data.msg);
                    }
                    //getSystemInfo();
                }
            });
        }


        //退出登录
        function outLogin() {
            layer.confirm('确定退出？', {
                btn: ['确定', '取消'] //可以无限个按钮
                , btn2: function (index, layero) {
                    //按钮【按钮三】的回调
                    //return false;// 开启该代码可禁止点击该按钮关闭
                }
            }, function (index) {//第一个按钮回调
                $.ajax({
                    type: "get",
                    url: "../../AdminManage/adminOpear",
                    async: true,
                    data: "type=2",
                    success: function (data) {
                        if (data.status == 2001) {//需要登录
                            top.location.href = "../admin/";
                            return;
                        } else if (data.status == 1) {
                            window.location.href = "index.html";
                        } else {
                            layer.close(index);
                            layer.msg("系统繁忙");
                        }
                    },
                });

            });
        }


    </script>

</head>
<body>
<!-- 顶部开始 -->
<div class="container">
    <div class="logo"><a href="./home.jsp"><img src="img/logo.png" style="width: 38px;">&nbsp;<span
            id="title">vpay云购系统</span></a></div>
    <div class="left_open">
        <i title="展开左侧栏" class="iconfont">&#xe699;</i>
    </div>


    <ul class="layui-nav left fast-add" lay-filter="">
        <li class="layui-nav-item">
            <a href="javascript:;">+工具</a>
            <dl class="layui-nav-child"> <!-- 二级菜单 -->
                <dd><a onclick="x_admin_show('百度','http://www.baidu.com')"><i class="iconfont">&#xe6a2;</i>百度</a></dd>
                <!-- <dd><a onclick="x_admin_show('图片','http://www.baidu.com')"><i class="iconfont">&#xe6a8;</i>图片</a></dd>
                 <dd><a onclick="x_admin_show('用户','http://www.baidu.com')"><i class="iconfont">&#xe6b8;</i>用户</a></dd> -->
            </dl>
        </li>
    </ul>


    <ul class="layui-nav right" lay-filter="">
        <li class="layui-nav-item">
            <a href="javascript:;"><span id="username">admin</span></a>
            <dl class="layui-nav-child"> <!-- 二级菜单 -->
                <!-- <dd><a onclick="x_admin_show('个人信息','http://www.baidu.com')">个人信息</a></dd>
                <dd><a onclick="x_admin_show('切换帐号','http://www.baidu.com')">切换帐号</a></dd> -->
                <dd><a style="cursor: pointer;" onclick="outLogin()">退出</a></dd>
            </dl>
        </li>
        <li class="layui-nav-item to-index"><a href="../../">前台首页</a></li>
    </ul>

</div>
<!-- 顶部结束 -->
<!-- 中部开始 -->
<!-- 左侧菜单开始 -->
<div class="left-nav">
    <div id="side-nav">
        <ul id="nav">


            <!-- 模板内容 -->


            <% if (PowerConfig.isHasPower(request, PowerConfig.ProductManage)) { %>
            <%--<li>--%>
            <%--<a _href="../adminInfo/ProductTypeManager.html">--%>
            <%--<i class="iconfont">&#xe6a7;</i>--%>
            <%--<cite>产品分类设置</cite>--%>
            <%--</a>--%>
            <%--</li >--%>

            <li>
                <a _href="../adminInfo/ProductManager.html">
                    <i class="iconfont">&#xe6a7;</i>
                    <cite>产品管理</cite>
                </a>
            </li>
            <%} %>


            <% if (PowerConfig.isHasPower(request, PowerConfig.MemberManager)) { %>


            <li>
                <a _href="../adminInfo/AuditRecharge.html">
                    <i class="iconfont">&#xe6a7;</i>
                    <cite>充值管理</cite>
                </a>
            </li>

            <%--<li>--%>
            <%--<a _href="../adminInfo/RechargeRecodeManager.html">--%>
            <%--<i class="iconfont">&#xe6a7;</i>--%>
            <%--<cite>消费记录</cite>--%>
            <%--</a>--%>
            <%--</li >--%>


            <%} %>

            <% if (PowerConfig.isHasPower(request, PowerConfig.OrderManager)) { %>

            <li>
                <a _href="../adminInfo/orderManager.html">
                    <i class="iconfont">&#xe6a7;</i>
                    <cite>订单列表</cite>
                </a>
            </li>


            <li>
                <a _href="../adminInfo/roundmap.html">
                    <i class="iconfont">&#xe6a7;</i>
                    <cite>轮播图设置</cite>
                </a>
            </li>
            <%} %>


            <% if (PowerConfig.isHasPower(request, PowerConfig.SystemSetting)) { %>
            <li>
                <a href="javascript:;">
                    <i class="iconfont">&#xe6ce;</i>
                    <cite>系统设置</cite>
                    <i class="iconfont nav_right">&#xe697;</i>
                </a>
                <ul class="sub-menu">

                    <% AdminModel adminModel = (AdminModel) request.getSession().getAttribute(NameValue.Admin_Session);
                        if (adminModel != null && adminModel.getAdmin_type() == 1) { %>

                    <li>
                        <a _href="../adminInfo/UserManager.html">
                            <i class="iconfont">&#xe6a7;</i>
                            <cite>会员管理</cite>
                        </a>
                    </li>

                    <li>
                        <a _href="../adminInfo/AdminManager.jsp">
                            <i class="iconfont">&#xe6a7;</i>
                            <cite>管理员账户</cite>
                        </a>
                    </li>


                    <%} %>

                    <%--<li>--%>
                    <%--<a _href="../adminInfo/UserStatistics.html">--%>
                    <%--<i class="iconfont">&#xe6a7;</i>--%>
                    <%--<cite>用户统计</cite>--%>
                    <%--</a>--%>
                    <%--</li >--%>

                    <%--<li>--%>
                    <%--<a _href="../adminInfo/MoneyStatistics.html">--%>
                    <%--<i class="iconfont">&#xe6a7;</i>--%>
                    <%--<cite>营业统计</cite>--%>
                    <%--</a>--%>
                    <%--</li >--%>

                    <!-- <li>
                        <a _href="../adminInfo/chat_record.html">
                            <i class="iconfont">&#xe6a7;</i>
                            <cite>聊天记录</cite>
                        </a>
                    </li > -->

                </ul>
            </li>
            <%} %>

        </ul>
    </div>
</div>
<!-- <div class="x-slide_left"></div> -->
<!-- 左侧菜单结束 -->
<!-- 右侧主体开始 -->
<div class="page-content">
    <div class="layui-tab tab" lay-filter="xbs_tab" lay-allowclose="false">
        <ul class="layui-tab-title">
            <li>默认显示</li>
        </ul>
        <div class="layui-tab-content">
            <div class="layui-tab-item layui-show">
                <iframe src='../adminInfo/ProductManager.html' frameborder="0" scrolling="yes"
                        class="x-iframe"></iframe>
            </div>
        </div>
    </div>
</div>
<div class="page-content-bg"></div>
<!-- 右侧主体结束 -->
<!-- 中部结束 -->
<!-- 底部开始 -->
<div class="footer">
    <div class="copyright">Copyright ©2018</div>
</div>
<!-- 底部结束 -->

</body>
</html>