package com.library.util.turnpay;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;


public class HttpUtil {
    /**
     * 
     * @param url
     * @param data
     * @return
     * @throws Exception
     */
    public static String postHttpRequest(String url, String data) {
        // 创建链接
        HttpURLConnection hconn = null;
        OutputStream os = null;
        InputStream is = null;
        BufferedReader reader = null;
        String returneddata = "";
        try {
            hconn = (HttpURLConnection) new URL(url).openConnection();
            hconn.setRequestMethod("POST"); // 设置为post请求
            hconn.setDoInput(true);
            hconn.setDoOutput(true);
            hconn.setUseCaches(false);
            hconn.setRequestProperty("Content-Type","application/x-www-form-urlencoded");
            hconn.setConnectTimeout(30000); // 30s
            hconn.setReadTimeout(30000); // 30s
            
            os = hconn.getOutputStream();
            byte[] f = data.getBytes("UTF-8");
            os.write(f, 0, f.length);
            os.flush();
            // 接收数据
            int code = hconn.getResponseCode();
            String sCurrentLine = "";
            // url访问成功
            if (code == 200)
            {
                is = hconn.getInputStream();
                reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while (null != (sCurrentLine = reader.readLine())){
                    if (sCurrentLine.length() > 0){
                        returneddata = returneddata + sCurrentLine.trim();
                    }
                }
            }
//            System.out.println("http-code:" + code);
            
        } catch (Exception e) {
            
            e.printStackTrace();
        } finally {
            if (hconn != null) {
                hconn.disconnect();
            }
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null)
            {
                try
                {
                    reader.close();
                    reader = null;
                } catch (Exception e)
                {
                    e.printStackTrace();
                }
            }
        }
        return returneddata;
    }
    
    public static void main(String[] args) {
//        String back = HttpUtil.postHttpRequest("http://210.74.1.48:8080/ks_onlpay/gateways/trans", "merId=818310048160000&transData=6B8129F821B53B04AC226782D30B169C4A5840FE1926626E4422D2B00E3DB75225E65E77EA7EBF9B9B6AC7BACCA9CBD698F42207534338C3D3FD472323271755A541175FD38CEC8BFE3900E715D99F258902B9F2E320022E450A06CA8DD31CD6EA7E410F8365A136E1BDB912B1F4A74CCA10CE816F33F83513E411BB77D70D6AFB1A82FAA9A3033993C6127C92801C280C0A983B56A7CC565C326983E7812A18665AF434CFE4CF89D2ECBB80D6558CFB21C7CE195A378F43518D72B5639EFE12ADA9B82C8AD0CA97D521F55A1420CD6D0916E2EC92234579E69B78EE1206A9F3BB3A462BE9EE2F0AA1DBB607AA158662257B3C22356F188E6FF3B2E3403501A3F25656E5A8B35CF1DE673D947E6F54E79D37236FAFD3738D2487C6168D3759BBD42A4C683D121338291EA53786AE931873202A6F8C237029E8C5BF7878592ACD8EA23894745447E663C3B701DF63099A26AC56FF9813AC7AFC90C943D20A2059B242B5AF5E90B1DF372E3526445A7D09EA78508708BB263D9285A759D29BA442320DA05FB475FAD28B65986F1DEF3311");
          String back = HttpUtil.postHttpRequest("http://210.74.1.48:8080/ks_onlpay/gateways/trans", "merId=818310048160000&transData=6B8129F821B53B04AC226782D30B169C4A5840FE1926626E4422D2B00E3DB75225E65E77EA7EBF9B9B6AC7BACCA9CBD698F42207534338C3D3FD472323271755DF71BD948BA0B216C8B7BAD224FD9152A28ACE1DC606FEDEED82914DB7F3D35FD38609EB2E0DCA069EC015EE8CAA66D8CA10CE816F33F83513E411BB77D70D6AFB1A82FAA9A3033993C6127C92801C280C0A983B56A7CC565C326983E7812A18665AF434CFE4CF89D2ECBB80D6558CFB21C7CE195A378F43518D72B5639EFE12ADA9B82C8AD0CA97D521F55A1420CD6D0916E2EC92234579E69B78EE1206A9F3BB3A462BE9EE2F0AA1DBB607AA158662257B3C22356F188E6FF3B2E3403501A3F25656E5A8B35CF1DE673D947E6F54E79D37236FAFD3738D2487C6168D3759BBD42A4C683D121338291EA53786AE931873202A6F8C237029E8C5BF7878592ACD8EA23894745447E663C3B701DF63099AFBCCE6E69C9B6543FEF02F17E0B503F6EF498AE53AC032B9D30F8ADB8BDBDA4DBCDB9E2737B6DD05CFC2D2CF19226EAB320DA05FB475FAD28B65986F1DEF3311");

        System.out.println(back);
    }
}
