package com.library.util.queue;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;


/**
 * <p>
 * Title: PushBlockQueue
 * </p> 
 * <p>
 * Description:TODO
 * </p> 
 * <p>
 * Company: YouJiang
 * </p> 
 *
 * @author feng
 * @date 2017年6月26日 下午4:45:32
 * @version 1.0
 */
public class PushBlockQueue extends LinkedBlockingQueue<PushBlockQueueRun>{
	private static final long serialVersionUID = -8224792866430647454L;
    private static ExecutorService es;//线程池
    private boolean flag = false;
    /**
     * 队列监听启动
     */
    public PushBlockQueue(int amount) {
    	es = Executors.newFixedThreadPool(amount);
	}
    public void start(){
        if(!this.flag){
            this.flag = true;
        }else{
            throw new IllegalArgumentException("The queue is already on, and no restart is allowed.");
        }
        new Thread(new Runnable(){
            @Override
            public void run() {
                while(flag){
                    try {
                        Object obj = take();//使用阻塞模式获取队列消息
                        //将获取消息交由线程池处理
                        es.execute(new PushBlockQueueHandler((PushBlockQueueRun)obj));
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        
    }
    
    /**
     * 停止队列监听
     */
    public void stop(){
        this.flag = false;
    }
	
	
	
}
