package com.library.mapper;

import org.apache.ibatis.annotations.Param;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

/**
 * 后台Mapper
 * @author Administrator
 *
 */
public interface AdminMapper {

	/**
	 * 分页查找会员
	 */
	public List<Map<String,Object>> FindAllUser(@Param("page") int page, @Param("number") int number);

	/**
	 * 查找产品
	 */
	public List<Map<String ,Object >> FindAllProductByAdmin(@Param("page") Integer page,
                                                            @Param("number") Integer number,
                                                            @Param("by_type_id")Integer by_type_id,
                                                            @Param("startTime")Timestamp startTime,
                                                            @Param("endTime")Timestamp endTime);

    /**
     * 查找参与夺宝人员
     * @param page
     * @param number
     * @param state
     * @param startTime
     * @param endTime
     * @return
     */
    public List<Map<String , Object>> FindParticipant(@Param("page") Integer page,
                                                      @Param("number") Integer number,
                                                      @Param("id")Integer id,
                                                      @Param("state")Integer state,
                                                      @Param("startTime")Timestamp startTime,
                                                      @Param("endTime")Timestamp endTime);


	/**
	 * 按状态获取审核充值记录
	 */
	public List<Map<String,Object>> FinfAuditRechargeByStatus(@Param("status")int status,@Param("start")Integer start,@Param("number")Integer number
															,@Param("key_word")String key_word);

	/**
	 * 查找轮播图通过id
	 */
	public Map<String,Object> findACarousel(@Param("id")int id);

/**
	 * 获取轮播图
	 */
	public List<Map<String,Object>> FindHomeImage(@Param("start")Integer start,@Param("number")Integer number);
}
