/*
 * Decompiled with CFR 0.152.
 */
package com.fivestars.interfaces.bbs.client;

import com.fivestars.interfaces.bbs.client.PHPFunctions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Client
extends PHPFunctions {
    public static boolean IN_UC = true;
    public static String UC_IP = "127.0.0.1";
    public static String UC_API = "http://localhost/uc";
    public static String UC_CONNECT = "";
    public static String UC_KEY = "123456";
    public static String UC_APPID = "3";
    public static String UC_CLIENT_VERSION = "1.0";
    public static String UC_CLIENT_RELEASE = "20090212";
    public static String UC_ROOT = "";
    public static String UC_DATADIR = String.valueOf(UC_ROOT) + "./data/";
    public static String UC_DATAURL = "UC_API/data";
    public static String UC_API_FUNC = UC_CONNECT.equals("mysql") ? "uc_api_mysql" : "uc_api_post";
    public static String[] uc_controls = new String[0];

    static {
        InputStream in = Client.class.getClassLoader().getResourceAsStream("config.properties");
        Properties properties = new Properties();
        try {
            properties.load(in);
            UC_API = properties.getProperty("UC_API");
            UC_IP = properties.getProperty("UC_IP");
            UC_KEY = properties.getProperty("UC_KEY");
            UC_APPID = properties.getProperty("UC_APPID");
            UC_CONNECT = properties.getProperty("UC_CONNECT");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String uc_serialize(String $arr, int $htmlon) {
        return $arr;
    }

    protected String uc_unserialize(String $s) {
        return $s;
    }

    protected String uc_addslashes(String $string, int $force, boolean $strip) {
        return $string;
    }

    protected String daddslashes(String $string, int $force) {
        return this.uc_addslashes($string, $force, false);
    }

    protected String uc_stripslashes(String $string) {
        return $string;
    }

    public String uc_api_post(String $module, String $action, Map<String, Object> $arg) {
        StringBuffer $s = new StringBuffer();
        String $sep = "";
        for (String $k : $arg.keySet()) {
            Object $v = $arg.get($k);
            $k = this.urlencode($k);
            if ($v.getClass().isAssignableFrom(Map.class)) {
                String $s2 = "";
                String $sep2 = "";
                for (String $k2 : ((Map)$v).keySet()) {
                    Object $v2 = ((Map)$v).get($k2);
                    $k2 = this.urlencode($k2);
                    $s2 = String.valueOf($s2) + $sep2 + "{" + $k + "}[" + $k2 + "]=" + this.urlencode(this.uc_stripslashes(String.valueOf($v2)));
                    $sep2 = "&";
                }
                $s.append($sep).append($s2);
            } else {
                $s.append($sep).append($k).append("=").append(this.urlencode(this.uc_stripslashes(String.valueOf($v))));
            }
            $sep = "&";
        }
        String $postdata = this.uc_api_requestdata($module, $action, $s.toString(), "");
        return this.uc_fopen2(String.valueOf(UC_API) + "/index.php", 500000, $postdata, "", true, UC_IP, 20, true);
    }

    protected String uc_api_requestdata(String $module, String $action, String $arg, String $extra) {
        String $input = this.uc_api_input($arg);
        String $post = "m=" + $module + "&a=" + $action + "&inajax=2&release=" + UC_CLIENT_RELEASE + "&input=" + $input + "&appid=" + UC_APPID + $extra;
        return $post;
    }

    protected String uc_api_url(String $module, String $action, String $arg, String $extra) {
        String $url = String.valueOf(UC_API) + "/index.php?" + this.uc_api_requestdata($module, $action, $arg, $extra);
        return $url;
    }

    public String uc_api_input(String $data) {
        String $s = this.urlencode(this.uc_authcode(String.valueOf($data) + "&agent=" + this.md5("") + "&time=" + this.time(), "ENCODE", UC_KEY));
        return $s;
    }

    public String uc_api_mysql(String $model, String $action, Map $args) {
        if ($action.charAt(0) != '_') {
            return null;
        }
        return "";
    }

    public String uc_authcode(String $string, String $operation) {
        return this.uc_authcode($string, $operation, null);
    }

    public String uc_authcode(String $string, String $operation, String $key) {
        return this.uc_authcode($string, $operation, $key, 0);
    }

    public String uc_authcode(String $string, String $operation, String $key, int $expiry) {
        int $ckey_length = 4;
        $key = this.md5($key != null ? $key : UC_KEY);
        String $keya = this.md5(this.substr($key, 0, 16));
        String $keyb = this.md5(this.substr($key, 16, 16));
        String $keyc = $ckey_length > 0 ? ($operation.equals("DECODE") ? this.substr($string, 0, $ckey_length) : this.substr(this.md5(this.microtime()), -$ckey_length)) : "";
        String $cryptkey = String.valueOf($keya) + this.md5(String.valueOf($keya) + $keyc);
        int $key_length = $cryptkey.length();
        $string = $operation.equals("DECODE") ? this.base64_decode(this.substr($string, $ckey_length)) : String.valueOf(this.sprintf("%010d", $expiry > 0 ? (long)$expiry + this.time() : 0L)) + this.substr(this.md5(String.valueOf($string) + $keyb), 0, 16) + $string;
        int $string_length = $string.length();
        StringBuffer $result1 = new StringBuffer();
        int[] $box = new int[256];
        int i = 0;
        while (i < 256) {
            $box[i] = i;
            ++i;
        }
        int[] $rndkey = new int[256];
        int $i = 0;
        while ($i <= 255) {
            $rndkey[$i] = $cryptkey.charAt($i % $key_length);
            ++$i;
        }
        int $j = 0;
        int $i2 = 0;
        while ($i2 < 256) {
            $j = ($j + $box[$i2] + $rndkey[$i2]) % 256;
            int $tmp = $box[$i2];
            $box[$i2] = $box[$j];
            $box[$j] = $tmp;
            ++$i2;
        }
        $j = 0;
        int $a = 0;
        int $i3 = 0;
        while ($i3 < $string_length) {
            $a = ($a + 1) % 256;
            $j = ($j + $box[$a]) % 256;
            int $tmp = $box[$a];
            $box[$a] = $box[$j];
            $box[$j] = $tmp;
            $result1.append((char)($string.charAt($i3) ^ $box[($box[$a] + $box[$j]) % 256]));
            ++$i3;
        }
        if ($operation.equals("DECODE")) {
            String $result = $result1.substring(0, $result1.length());
            if ((Integer.parseInt(this.substr($result.toString(), 0, 10)) == 0 || Long.parseLong(this.substr($result.toString(), 0, 10)) - this.time() > 0L) && this.substr($result.toString(), 10, 16).equals(this.substr(this.md5(String.valueOf(this.substr($result.toString(), 26)) + $keyb), 0, 16))) {
                return this.substr($result.toString(), 26);
            }
            return "";
        }
        return String.valueOf($keyc) + this.base64_encode($result1.toString()).replaceAll("=", "");
    }

    protected String uc_fopen2(String $url, int $limit, String $post, String $cookie, boolean $bysocket, String $ip, int $timeout, boolean $block) {
        $url = String.valueOf($url) + ($url.indexOf("?") > 0 ? "&" : "?__times__=1");
        return this.uc_fopen($url, $limit, $post, $cookie, $bysocket, $ip, $timeout, $block);
    }

    protected String uc_fopen(String $url, int $limit, String $post, String $cookie, boolean $bysocket, String $ip, int $timeout, boolean $block) {
        Socket $fp;
        StringBuffer $out;
        String $return;
        block10: {
            $return = "";
            String $host = "";
            String $path = "";
            int $port = 80;
            try {
                URL $matches = new URL($url);
                $host = $matches.getHost();
                String string = $matches.getPath() != null ? String.valueOf($matches.getPath()) + ($matches.getQuery() != null ? "?" + $matches.getQuery() : "") : ($path = "/");
                if ($matches.getPort() > 0) {
                    $port = $matches.getPort();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            $out = new StringBuffer();
            if ($post != null && $post.length() > 0) {
                $out.append("POST ").append($path).append(" HTTP/1.0\r\n");
                $out.append("Accept: */*\r\n");
                $out.append("Accept-Language: zh-cn\r\n");
                $out.append("Content-Type: application/x-www-form-urlencoded\r\n");
                $out.append("User-Agent: \r\n");
                $out.append("Host: ").append($host).append("\r\n");
                $out.append("Content-Length: ").append($post.length()).append("\r\n");
                $out.append("Connection: Close\r\n");
                $out.append("Cache-Control: no-cache\r\n");
                $out.append("Cookie: \r\n\r\n");
                $out.append($post);
            } else {
                $out.append("GET $path HTTP/1.0\r\n");
                $out.append("Accept: */*\r\n");
                $out.append("Accept-Language: zh-cn\r\n");
                $out.append("User-Agent: Java/1.5.0_01\r\n");
                $out.append("Host: $host\r\n");
                $out.append("Connection: Close\r\n");
                $out.append("Cookie: $cookie\r\n\r\n");
            }
            $fp = new Socket($ip != null && $ip.length() > 10 ? $ip : $host, $port);
            if ($fp.isConnected()) break block10;
            return "";
        }
        try {
            String $data;
            String $header;
            OutputStream os = $fp.getOutputStream();
            os.write($out.toString().getBytes());
            InputStream ins = $fp.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
            while (($header = reader.readLine()) != null && !$header.equals("") && $header != "\r\n" && $header != "\n") {
            }
            while (($data = reader.readLine()) != null && !$data.equals("")) {
                $return = String.valueOf($return) + $data;
            }
            $fp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return $return;
    }

    public String uc_app_ls() {
        String $return = this.call_user_func(UC_API_FUNC, "app", "ls", null);
        return UC_CONNECT.equals("mysql") ? $return : this.uc_unserialize($return);
    }

    public String uc_user_register(String $username, String $password, String $email) {
        return this.uc_user_register($username, $password, $email, "", "");
    }

    public String uc_user_register(String $username, String $password, String $email, String $questionid, String $answer) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("username", $username);
        args.put("password", $password);
        args.put("email", $email);
        args.put("questionid", $questionid);
        args.put("answer", $answer);
        return this.call_user_func(UC_API_FUNC, "user", "register", args);
    }

    public String uc_user_login(String $username, String $password) {
        return this.uc_user_login($username, $password, 0, 0);
    }

    public String uc_user_login(String $username, String $password, int $isuid, int $checkques) {
        return this.uc_user_login($username, $password, $isuid, $checkques, "", "");
    }

    public String uc_user_login(String $username, String $password, int $isuid, int $checkques, String $questionid, String $answer) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("username", $username);
        args.put("password", $password);
        args.put("isuid", $isuid);
        args.put("checkques", $checkques);
        args.put("questionid", $questionid);
        args.put("answer", $answer);
        String $return = this.call_user_func(UC_API_FUNC, "user", "login", args);
        return UC_CONNECT.equals("mysql") ? $return : this.uc_unserialize($return);
    }

    public String uc_user_synlogin(int $uid) {
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("uid", $uid);
        String $return = this.uc_api_post("user", "synlogin", args);
        return $return;
    }

    public String uc_user_synlogout() {
        String $return = this.uc_api_post("user", "synlogout", new HashMap());
        return $return;
    }

    public String uc_get_user(String $username, int $isuid) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("username", $username);
        args.put("isuid", $isuid);
        String $return = this.call_user_func(UC_API_FUNC, "user", "get_user", args);
        return UC_CONNECT.equals("mysql") ? $return : this.uc_unserialize($return);
    }

    public String uc_user_edit(String $username, String $oldpw, String $newpw, String $email, int $ignoreoldpw, String $questionid, String $answer) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("username", $username);
        args.put("oldpw", $oldpw);
        args.put("newpw", $newpw);
        args.put("email", $email);
        args.put("ignoreoldpw", $ignoreoldpw);
        args.put("questionid", $questionid);
        args.put("answer", $answer);
        return this.call_user_func(UC_API_FUNC, "user", "edit", args);
    }

    public String uc_user_delete(String $uid) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("uid", $uid);
        return this.call_user_func(UC_API_FUNC, "user", "delete", args);
    }

    public String uc_user_deleteavatar(String $uid) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("uid", $uid);
        return this.uc_api_post("user", "deleteavatar", args);
    }
}

