/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.xml.XMLSchedulingDataProcessor;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;
import org.springframework.scheduling.quartz.ResourceLoaderClassLoadHelper;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class SchedulerAccessor
implements ResourceLoaderAware {
    private static Class<?> jobKeyClass;
    private static Class<?> triggerKeyClass;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean overwriteExistingJobs = false;
    private String[] jobSchedulingDataLocations;
    private List<JobDetail> jobDetails;
    private Map<String, Calendar> calendars;
    private List<Trigger> triggers;
    private SchedulerListener[] schedulerListeners;
    private JobListener[] globalJobListeners;
    private JobListener[] jobListeners;
    private TriggerListener[] globalTriggerListeners;
    private TriggerListener[] triggerListeners;
    private PlatformTransactionManager transactionManager;
    protected ResourceLoader resourceLoader;

    public SchedulerAccessor() {
        if (jobKeyClass == null && this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Spring's Quartz 1.x support is deprecated - please upgrade to Quartz 2.0+");
        }
    }

    public void setOverwriteExistingJobs(boolean overwriteExistingJobs) {
        this.overwriteExistingJobs = overwriteExistingJobs;
    }

    public void setJobSchedulingDataLocation(String jobSchedulingDataLocation) {
        this.jobSchedulingDataLocations = new String[]{jobSchedulingDataLocation};
    }

    public void setJobSchedulingDataLocations(String ... jobSchedulingDataLocations) {
        this.jobSchedulingDataLocations = jobSchedulingDataLocations;
    }

    public void setJobDetails(JobDetail ... jobDetails) {
        this.jobDetails = new ArrayList<JobDetail>(Arrays.asList(jobDetails));
    }

    public void setCalendars(Map<String, Calendar> calendars) {
        this.calendars = calendars;
    }

    public void setTriggers(Trigger ... triggers) {
        this.triggers = Arrays.asList(triggers);
    }

    public void setSchedulerListeners(SchedulerListener ... schedulerListeners) {
        this.schedulerListeners = schedulerListeners;
    }

    public void setGlobalJobListeners(JobListener ... globalJobListeners) {
        this.globalJobListeners = globalJobListeners;
    }

    @Deprecated
    public void setJobListeners(JobListener ... jobListeners) {
        this.jobListeners = jobListeners;
    }

    public void setGlobalTriggerListeners(TriggerListener ... globalTriggerListeners) {
        this.globalTriggerListeners = globalTriggerListeners;
    }

    @Deprecated
    public void setTriggerListeners(TriggerListener ... triggerListeners) {
        this.triggerListeners = triggerListeners;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected void registerJobsAndTriggers() throws SchedulerException {
        TransactionStatus transactionStatus = null;
        if (this.transactionManager != null) {
            transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        }
        try {
            if (this.jobSchedulingDataLocations != null) {
                Iterator<String> clh = new ResourceLoaderClassLoadHelper(this.resourceLoader);
                clh.initialize();
                XMLSchedulingDataProcessor dataProcessor = new XMLSchedulingDataProcessor((ClassLoadHelper)clh);
                for (String location : this.jobSchedulingDataLocations) {
                    dataProcessor.processFileAndScheduleJobs(location, this.getScheduler());
                }
            }
            if (this.jobDetails != null) {
                for (JobDetail jobDetail : this.jobDetails) {
                    this.addJobToScheduler(jobDetail);
                }
            } else {
                this.jobDetails = new LinkedList<JobDetail>();
            }
            if (this.calendars != null) {
                for (String calendarName : this.calendars.keySet()) {
                    Calendar calendar = this.calendars.get(calendarName);
                    this.getScheduler().addCalendar(calendarName, calendar, true, true);
                }
            }
            if (this.triggers != null) {
                for (Trigger trigger : this.triggers) {
                    this.addTriggerToScheduler(trigger);
                }
            }
        }
        catch (Throwable ex) {
            if (transactionStatus != null) {
                try {
                    this.transactionManager.rollback(transactionStatus);
                }
                catch (TransactionException tex) {
                    this.logger.error((Object)"Job registration exception overridden by rollback exception", ex);
                    throw tex;
                }
            }
            if (ex instanceof SchedulerException) {
                throw (SchedulerException)ex;
            }
            if (ex instanceof Exception) {
                throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage(), ex);
            }
            throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage());
        }
        if (transactionStatus != null) {
            this.transactionManager.commit(transactionStatus);
        }
    }

    private boolean addJobToScheduler(JobDetail jobDetail) throws SchedulerException {
        if (this.overwriteExistingJobs || !this.jobDetailExists(jobDetail)) {
            this.getScheduler().addJob(jobDetail, true);
            return true;
        }
        return false;
    }

    private boolean addTriggerToScheduler(Trigger trigger) throws SchedulerException {
        boolean triggerExists = this.triggerExists(trigger);
        if (!triggerExists || this.overwriteExistingJobs) {
            JobDetail jobDetail = this.findJobDetail(trigger);
            if (jobDetail != null && !this.jobDetails.contains(jobDetail) && this.addJobToScheduler(jobDetail)) {
                this.jobDetails.add(jobDetail);
            }
            if (!triggerExists) {
                try {
                    this.getScheduler().scheduleJob(trigger);
                }
                catch (ObjectAlreadyExistsException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Unexpectedly found existing trigger, assumably due to cluster race condition: " + ex.getMessage() + " - can safely be ignored"));
                    }
                    if (this.overwriteExistingJobs) {
                        this.rescheduleJob(trigger);
                    }
                }
            } else {
                this.rescheduleJob(trigger);
            }
            return true;
        }
        return false;
    }

    private JobDetail findJobDetail(Trigger trigger) {
        if (trigger instanceof JobDetailAwareTrigger) {
            return ((JobDetailAwareTrigger)trigger).getJobDetail();
        }
        try {
            Map jobDataMap = (Map)ReflectionUtils.invokeMethod((Method)Trigger.class.getMethod("getJobDataMap", new Class[0]), (Object)trigger);
            return (JobDetail)jobDataMap.remove("jobDetail");
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Inconsistent Quartz API: " + ex);
        }
    }

    private boolean jobDetailExists(JobDetail jobDetail) throws SchedulerException {
        if (jobKeyClass != null) {
            try {
                Method getJobDetail = Scheduler.class.getMethod("getJobDetail", jobKeyClass);
                Object key = ReflectionUtils.invokeMethod((Method)JobDetail.class.getMethod("getKey", new Class[0]), (Object)jobDetail);
                return ReflectionUtils.invokeMethod((Method)getJobDetail, (Object)this.getScheduler(), (Object[])new Object[]{key}) != null;
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Inconsistent Quartz 2.0 API: " + ex);
            }
        }
        return this.getScheduler().getJobDetail(jobDetail.getName(), jobDetail.getGroup()) != null;
    }

    private boolean triggerExists(Trigger trigger) throws SchedulerException {
        if (triggerKeyClass != null) {
            try {
                Method getTrigger = Scheduler.class.getMethod("getTrigger", triggerKeyClass);
                Object key = ReflectionUtils.invokeMethod((Method)Trigger.class.getMethod("getKey", new Class[0]), (Object)trigger);
                return ReflectionUtils.invokeMethod((Method)getTrigger, (Object)this.getScheduler(), (Object[])new Object[]{key}) != null;
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Inconsistent Quartz 2.0 API: " + ex);
            }
        }
        return this.getScheduler().getTrigger(trigger.getName(), trigger.getGroup()) != null;
    }

    private void rescheduleJob(Trigger trigger) throws SchedulerException {
        if (triggerKeyClass != null) {
            try {
                Method rescheduleJob = Scheduler.class.getMethod("rescheduleJob", triggerKeyClass, Trigger.class);
                Object key = ReflectionUtils.invokeMethod((Method)Trigger.class.getMethod("getKey", new Class[0]), (Object)trigger);
                ReflectionUtils.invokeMethod((Method)rescheduleJob, (Object)this.getScheduler(), (Object[])new Object[]{key, trigger});
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Inconsistent Quartz 2.0 API: " + ex);
            }
        } else {
            this.getScheduler().rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void registerListeners() throws SchedulerException {
        boolean quartz2;
        Object target;
        try {
            Method getListenerManager = Scheduler.class.getMethod("getListenerManager", new Class[0]);
            target = ReflectionUtils.invokeMethod((Method)getListenerManager, (Object)this.getScheduler());
            quartz2 = true;
        }
        catch (NoSuchMethodException ex) {
            target = this.getScheduler();
            quartz2 = false;
        }
        Class<?> targetClass = target.getClass();
        try {
            LinkedList emptyMatchers;
            SchedulerListener listener;
            int n;
            int n2;
            SchedulerListener[] schedulerListenerArray;
            if (this.schedulerListeners != null) {
                Method method = targetClass.getMethod("addSchedulerListener", SchedulerListener.class);
                schedulerListenerArray = this.schedulerListeners;
                n2 = schedulerListenerArray.length;
                for (n = 0; n < n2; ++n) {
                    listener = schedulerListenerArray[n];
                    ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])new Object[]{listener});
                }
            }
            if (this.globalJobListeners != null) {
                if (quartz2) {
                    Method method = targetClass.getMethod("addJobListener", JobListener.class, List.class);
                } else {
                    Method method = targetClass.getMethod("addGlobalJobListener", JobListener.class);
                }
                schedulerListenerArray = this.globalJobListeners;
                n2 = schedulerListenerArray.length;
                for (n = 0; n < n2; ++n) {
                    void var4_8;
                    listener = schedulerListenerArray[n];
                    if (quartz2) {
                        emptyMatchers = new LinkedList();
                        ReflectionUtils.invokeMethod((Method)var4_8, (Object)target, (Object[])new Object[]{listener, emptyMatchers});
                        continue;
                    }
                    ReflectionUtils.invokeMethod((Method)var4_8, (Object)target, (Object[])new Object[]{listener});
                }
            }
            if (this.jobListeners != null) {
                JobListener[] jobListenerArray = this.jobListeners;
                int n3 = jobListenerArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    JobListener listener2 = jobListenerArray[n2];
                    if (quartz2) {
                        throw new IllegalStateException("Non-global JobListeners not supported on Quartz 2 - manually register a Matcher against the Quartz ListenerManager instead");
                    }
                    this.getScheduler().addJobListener(listener2);
                }
            }
            if (this.globalTriggerListeners != null) {
                if (quartz2) {
                    Method method = targetClass.getMethod("addTriggerListener", TriggerListener.class, List.class);
                } else {
                    Method method = targetClass.getMethod("addGlobalTriggerListener", TriggerListener.class);
                }
                TriggerListener[] triggerListenerArray = this.globalTriggerListeners;
                n2 = triggerListenerArray.length;
                for (int listener2 = 0; listener2 < n2; ++listener2) {
                    void var4_14;
                    listener = triggerListenerArray[listener2];
                    if (quartz2) {
                        emptyMatchers = new LinkedList();
                        ReflectionUtils.invokeMethod((Method)var4_14, (Object)target, (Object[])new Object[]{listener, emptyMatchers});
                        continue;
                    }
                    ReflectionUtils.invokeMethod((Method)var4_14, (Object)target, (Object[])new Object[]{listener});
                }
            }
            if (this.triggerListeners != null) {
                for (TriggerListener listener3 : this.triggerListeners) {
                    if (quartz2) {
                        throw new IllegalStateException("Non-global TriggerListeners not supported on Quartz 2 - manually register a Matcher against the Quartz ListenerManager instead");
                    }
                    this.getScheduler().addTriggerListener(listener3);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("Expected Quartz API not present: " + noSuchMethodException);
        }
    }

    protected abstract Scheduler getScheduler();

    static {
        try {
            jobKeyClass = ClassUtils.forName((String)"org.quartz.JobKey", (ClassLoader)SchedulerAccessor.class.getClassLoader());
            triggerKeyClass = ClassUtils.forName((String)"org.quartz.TriggerKey", (ClassLoader)SchedulerAccessor.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            jobKeyClass = null;
            triggerKeyClass = null;
        }
    }
}

