package com.library.controller;

import com.google.gson.Gson;
import com.library.TopUp.Http.HttpUtils;
import com.library.TopUp.Statel.HttpClientUtils;
import com.library.TopUp.Statel.SeatelSentUtils;
import com.library.TopUp.cellcard.CellcardSentUtils;
import com.library.TopUp.model.ResultsModel;
import com.library.respcode.ServerResponse;
import com.library.service.AdminService;
import com.library.service.CommService;
import com.library.util.QiniuUtils;
import com.wechat.pay.MD5Util;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/*
 *  @项目名：  yunVpay
 *  @包名：    com.library.controller
 *  @文件名:   CommonController
 *  @创建者:   zhouzhuo
 *  @创建时间:  2018/11/1 14:50
 *  @描述：    TODO
 */
@Controller
@RequestMapping("/Common")
public class CommonController {

    @Resource
    private CommService commService;

    @Resource
    private HttpServletRequest request;

    //获取七牛云的token
    @ResponseBody
    @RequestMapping("/FindQNYToken")
    private ServerResponse FindQNYToken() {
        String token = QiniuUtils.getUpToken();
        return ServerResponse.createBySuccess(token);
    }

    //Recharge
    @ResponseBody
    @RequestMapping("recharge")
    private ServerResponse recharge() {
        return commService.Recharge();
    }

    //登录
    @ResponseBody
    @RequestMapping("adminLogin")
    private ServerResponse adminLogin() {
        return commService.adminLogin();
    }

    //登录
    @ResponseBody
    @RequestMapping("test1")
    private ServerResponse test() {

        String phone = "0189464112";
        String json = SeatelSentUtils.checkPhone(phone);
        return ServerResponse.createBySuccess(json);
    }

    //登录
    @ResponseBody
    @RequestMapping("test2")
    private ServerResponse test2() {

        String phone = "0189464112";
        String json = SeatelSentUtils.checkPhone2(phone);
        return ServerResponse.createBySuccess(json);
    }

    //登录
    @ResponseBody
    @RequestMapping("test3")
    private ServerResponse test3() {

        String json = SeatelSentUtils.queryAgentFee();
        return ServerResponse.createBySuccess(json);
    }

    @ResponseBody
    @RequestMapping("test4")
    private ServerResponse test4() {

        String phone = "0189464112";
        String json = SeatelSentUtils.crmRecharge(phone, 1);
        return ServerResponse.createBySuccess(json);
    }

    @ResponseBody
    @RequestMapping("test5")
    private ServerResponse test5() {

        String str = request.getParameter("str");
        String type = request.getParameter("type");
        String json = SeatelSentUtils.queryCrmRecharge(str);
        return ServerResponse.createBySuccess(json);
    }

    @ResponseBody
    @RequestMapping("sentTopUp")
    private ServerResponse sentTopUp() {
        String phone = request.getParameter("phone");
//        String phone = "0189464112";
        ResultsModel resultsModel = SeatelSentUtils.sentTopUp(phone,1);
        return ServerResponse.createBySuccess(new Gson().toJson(resultsModel));
    }


}
