package com.library.util.currency;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

/**
 * 
 * @ClassName: UUIDUtils
 * @Description: UUID工具类
 * @author: lin
 * @date: 2017年5月11日 下午3:06:08
 * @version:
 */
public class UUIDUtils{
	
	/**
	 * 
	 * @Title: generateUUID
	 * @Description: 生成UUID
	 * @return UUID
	 * @returnType: String
	 * @author: lin
	 * @date: 2017年5月11日 下午2:17:26
	 */
	public static String generateUUID() {
		String uuid = UUID.randomUUID().toString();
		return uuid.replace("-", "");// 替换掉-号
	}
	
	/**
	 * 
	 * @Title: iterceptDigitUUID
	 * @Description: 截取固定位数的UUID 
	 * @param digit 位数  1~32
	 * @return
	 * @returnType: String
	 * @author: lin
	 * @date: May 13, 2017 11:43:55 AM
	 */
	public static String iterceptDigitUUID(Integer digit){
		if(digit < 0 || digit >32){
			return null;
		}
		return generateUUID().substring(0, digit);
	}
	public static SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmSSS");
	private static String addstr = "000000000000";
	/****
	 * 
	 * Description:TODO
	 * @author feng
	 * @date 2017年5月23日 上午9:49:38
	 * @version 1.0
	 * @return
	 */
	public static String generateOrderId(){
		String id=df.format(new Date())+generate();
		if(id.length()<23){
			return id+addstr.substring(0, 23-id.length());
		}else{
			return id;
		}
	}
	private static String generate(){
		int code = UUID.randomUUID().hashCode();
		if(code>0){
			return String.valueOf(code);
		}else{
			return String.valueOf(-code);
		}
	}
	public static void main(String[] args) {
		String uuid = generateUUID();
		System.out.println(uuid);
	}
}
