/*
 * Decompiled with CFR 0.152.
 */
package remoting.protocol.tcp;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import remoting.protocol.CompatibleUtil;
import remoting.protocol.NotSupportedException;
import remoting.protocol.ProtocolStreamHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpProtocolHandle
extends ProtocolStreamHandle {
    private static final byte[] PREAMBLE = ".NET".getBytes();

    public TcpProtocolHandle(ByteBuffer source) {
        super(source);
    }

    public String ReadPreamble() {
        return new String(new byte[]{(byte)this.ReadByte(), (byte)this.ReadByte(), (byte)this.ReadByte(), (byte)this.ReadByte()});
    }

    public void WritePreamble() {
        this.WriteBytes(PREAMBLE);
    }

    public int ReadMajorVersion() {
        return this.ReadByte();
    }

    public void WriteMajorVersion() {
        this.WriteByte((byte)1);
    }

    public int ReadMinorVersion() {
        return this.ReadByte();
    }

    public void WriteMinorVersion() {
        this.WriteByte((byte)0);
    }

    public short ReadOperation() {
        return this.ReadUInt16();
    }

    public void WriteOperation(short value) {
        this.WriteUInt16(value);
    }

    public short ReadContentDelimiter() {
        return this.ReadUInt16();
    }

    public void WriteContentDelimiter(short value) {
        this.WriteUInt16(value);
    }

    public int ReadContentLength() {
        this._contentLength = this.ReadInt32();
        return this._contentLength;
    }

    public void WriteContentLength(int value) {
        this._contentLength = value;
        this.WriteInt32(this._contentLength);
    }

    public HashMap<String, Object> ReadTransportHeaders() throws NotSupportedException {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        short headerType = this.ReadUInt16();
        while (headerType != 0) {
            if (headerType == 1) {
                dict.put(this.ReadCountedString(), this.ReadCountedString());
            } else if (headerType == 4) {
                this.ReadByte();
                dict.put("RequestUri", this.ReadCountedString());
            } else if (headerType == 2) {
                this.ReadByte();
                dict.put("StatusCode", this.ReadUInt16());
            } else if (headerType == 3) {
                this.ReadByte();
                dict.put("StatusPhrase", this.ReadCountedString());
            } else if (headerType == 6) {
                this.ReadByte();
                dict.put("ContentType", this.ReadCountedString());
            } else if (!this.readExtendedHeader(headerType, dict)) {
                byte headerFormat = (byte)this.ReadByte();
                switch (headerFormat) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.ReadCountedString();
                        break;
                    }
                    case 2: {
                        this.ReadByte();
                        break;
                    }
                    case 3: {
                        this.ReadUInt16();
                        break;
                    }
                    case 4: {
                        this.ReadInt32();
                        break;
                    }
                    default: {
                        throw new NotSupportedException();
                    }
                }
            }
            headerType = this.ReadUInt16();
        }
        return dict;
    }

    public void WriteTransportHeaders(HashMap<String, Object> headers) {
        if (headers != null) {
            for (Map.Entry<String, Object> i : headers.entrySet()) {
                if (i.getKey().equalsIgnoreCase("StatusCode")) {
                    this.WriteStatusCodeHeader(Short.parseShort(i.getValue().toString()));
                    continue;
                }
                if (i.getKey().equalsIgnoreCase("StatusPhrase")) {
                    this.WriteStatusPhraseHeader(i.getValue().toString());
                    continue;
                }
                if (i.getKey().equalsIgnoreCase("ContentType")) {
                    this.WriteContentTypeHeader(i.getValue().toString());
                    continue;
                }
                if (i.getKey().equalsIgnoreCase("RequestUri")) {
                    this.WriteRequestUriHeader(i.getValue().toString());
                    continue;
                }
                if (this.writeExtendedHeader(i)) continue;
                this.WriteCustomHeader(i.getKey(), i.getValue().toString());
            }
        }
        this.WriteUInt16((short)0);
    }

    protected boolean readExtendedHeader(short headerType, HashMap<String, Object> dict) throws NotSupportedException {
        return false;
    }

    protected boolean writeExtendedHeader(Map.Entry<String, Object> entry) {
        return false;
    }

    protected final short ReadUInt16() {
        return (short)(this.ReadByte() & 0xFF | this.ReadByte() << 8);
    }

    protected final void WriteUInt16(short value) {
        this.WriteByte((byte)value);
        this.WriteByte((byte)(value >> 8));
    }

    protected int ReadInt32() {
        this._source.order(ByteOrder.LITTLE_ENDIAN);
        int value = this._source.getInt();
        this._source.order(ByteOrder.BIG_ENDIAN);
        return value;
    }

    protected void WriteInt32(int value) {
        this._source.order(ByteOrder.LITTLE_ENDIAN);
        this._source.putInt(value);
        this._source.order(ByteOrder.BIG_ENDIAN);
    }

    protected final String ReadCountedString() throws NotSupportedException {
        byte format = (byte)this.ReadByte();
        int size = this.ReadInt32();
        if (size > 0) {
            byte[] data = this.ReadBytes(size);
            switch (format) {
                case 0: {
                    return CompatibleUtil.newString(data, "unicode");
                }
                case 1: {
                    return CompatibleUtil.newString(data, "UTF-8");
                }
            }
            throw new NotSupportedException();
        }
        return null;
    }

    protected final void WriteCountedString(String value) {
        int strLength = 0;
        if (value != null) {
            strLength = value.length();
        }
        if (strLength > 0) {
            byte[] strBytes = CompatibleUtil.getBytes(value, "UTF-8");
            this.WriteByte((byte)1);
            this.WriteInt32(strBytes.length);
            this.WriteBytes(strBytes);
        } else {
            this.WriteByte((byte)0);
            this.WriteInt32(0);
        }
    }

    private void WriteRequestUriHeader(String value) {
        this.WriteUInt16((short)4);
        this.WriteByte((byte)1);
        this.WriteCountedString(value);
    }

    private void WriteContentTypeHeader(String value) {
        this.WriteUInt16((short)6);
        this.WriteByte((byte)1);
        this.WriteCountedString(value);
    }

    private void WriteStatusCodeHeader(short value) {
        this.WriteUInt16((short)2);
        this.WriteByte((byte)3);
        this.WriteUInt16(value);
    }

    private void WriteStatusPhraseHeader(String value) {
        this.WriteUInt16((short)3);
        this.WriteByte((byte)1);
        this.WriteCountedString(value);
    }

    private void WriteCustomHeader(String name, String value) {
        this.WriteUInt16((short)1);
        this.WriteCountedString(name);
        this.WriteCountedString(value);
    }
}

