/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.handler;

import com.taobao.top.link.embedded.websocket.WebSocket;
import com.taobao.top.link.embedded.websocket.exception.WebSocketException;
import com.taobao.top.link.embedded.websocket.frame.Frame;
import com.taobao.top.link.embedded.websocket.handler.StreamHandler;
import com.taobao.top.link.embedded.websocket.handler.StreamHandlerChain;
import java.nio.ByteBuffer;

public class WebSocketPipeline {
    private StreamHandlerChain startChain;
    private StreamHandlerChain lastChain;

    public void sendHandshakeUpstream(WebSocket ws, ByteBuffer buffer) throws WebSocketException {
        this.lastChain.nextHandshakeUpstreamHandler(ws, buffer);
    }

    public void sendHandshakeDownstream(WebSocket ws, ByteBuffer buffer) throws WebSocketException {
        this.startChain.nextHandshakeDownstreamHandler(ws, buffer);
    }

    public void sendUpstream(WebSocket ws, ByteBuffer buffer, Frame frame) throws WebSocketException {
        this.lastChain.nextUpstreamHandler(ws, buffer, frame);
    }

    public void sendDownstream(WebSocket ws, ByteBuffer buffer, Frame frame) throws WebSocketException {
        this.startChain.nextDownstreamHandler(ws, buffer, frame);
    }

    public void addStreamHandler(StreamHandler handler) {
        StreamHandlerChain c = new StreamHandlerChain(handler);
        if (this.startChain == null) {
            this.startChain = c;
            this.lastChain = c;
        } else {
            this.lastChain.add(c);
            this.lastChain = c;
        }
    }

    protected void finalize() throws Throwable {
        this.startChain.clear();
        super.finalize();
    }
}

