
package com.library.TopUp.mefont;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.library.TopUp.Http.HttpUtils;
import com.library.TopUp.Http.HttpsTool;
import com.library.TopUp.model.ResultsModel;
import org.apache.http.util.TextUtils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class MetfoneSentUtils {
    private static final String baseUrl = "https://payment.emoney.com.kh:8888/";
    private static final String PIN = "682504";
    private static final String MyAuthorization = "epa 5b83407f62da2bef2f20a463ffc0b5d2fbf6fab388531a297d7f00627cce3300";

    public MetfoneSentUtils() {
    }

    public static String initTel(String transAmount, String refId, String customerPhoneNumber) {
        Map params = new HashMap();
        params.put("serviceType", "TOPUP");
        params.put("transAmount", transAmount);
        params.put("currency", "USD");
        params.put("refId", refId);
        params.put("customerPhoneNumber", customerPhoneNumber);
        Map<String, String> heardMap = new HashMap();
        heardMap.put("Authorization", "epa 5b83407f62da2bef2f20a463ffc0b5d2fbf6fab388531a297d7f00627cce3300");
        heardMap.put("e-language", "English");
        heardMap.put("Content-Type", "application/json");
        heardMap.put("Accept", "application/json");
        String url = "https://payment.emoney.com.kh:8888/LASIA/telco/init";
        String str = HttpUtils.post(url, params, heardMap, 3000, 3000, "UTF-8");
        return str;
    }

    public static String confirmTel(String txPaymentTokenId) {
        Map<String, String> heardMap = new HashMap();
        heardMap.put("Authorization", "epa 5b83407f62da2bef2f20a463ffc0b5d2fbf6fab388531a297d7f00627cce3300");
        heardMap.put("e-language", "English");
        heardMap.put("Content-Type", "application/json");
        heardMap.put("Accept", "application/json");
        Map params = new HashMap();
        params.put("txPaymentTokenId", txPaymentTokenId);
        String conURL = "https://payment.emoney.com.kh:8888/LASIA/telco/confirm";
        String str = HttpUtils.post(conURL, params, heardMap, 3000, 3000, "UTF-8");
        return str;
    }

    public static String initTelPost(String transAmount, String refId, String customerPhoneNumber) {
        try {
            Map<String, String> params = new HashMap();
            params.put("serviceType", "TOPUP");
            params.put("transAmount", transAmount);
            params.put("currency", "USD");
            params.put("refId", refId);
            params.put("customerPhoneNumber", customerPhoneNumber);
            Map<String, String> heardMap = new HashMap();
            heardMap.put("Authorization", "epa 5b83407f62da2bef2f20a463ffc0b5d2fbf6fab388531a297d7f00627cce3300");
            heardMap.put("e-language", "English");
            heardMap.put("Content-Type", "application/json");
            heardMap.put("Accept", "application/json");
            String requestUrl = "https://payment.emoney.com.kh:8888/LASIA/telco/init";
            String str = HttpsTool.send((new Gson()).toJson(params), heardMap, requestUrl, "utf-8", "utf-8", 300000, 300000, "application/json");
            return str;
        } catch (Exception var7) {
            var7.getLocalizedMessage();
            return null;
        }
    }

    public static String confirmPost(String txPaymentTokenId) {
        try {
            Map<String, String> heardMap = new HashMap();
            heardMap.put("Authorization", "epa 5b83407f62da2bef2f20a463ffc0b5d2fbf6fab388531a297d7f00627cce3300");
            heardMap.put("e-language", "English");
            heardMap.put("Content-Type", "application/json");
            heardMap.put("Accept", "application/json");
            Map params = new HashMap();
            params.put("txPaymentTokenId", txPaymentTokenId);
            String conURL = "https://payment.emoney.com.kh:8888/LASIA/telco/confirm";
            String senc = HttpsTool.send((new Gson()).toJson(params), heardMap, conURL, "utf-8", "utf-8", 300000, 300000, "application/json");
            return senc;
        } catch (Exception var5) {
            var5.getLocalizedMessage();
            return null;
        }
    }

    public static String checkPayPost(String transDetailId, String refId) {
        try {
            Map<String, String> heardMap = new HashMap();
            heardMap.put("Authorization", "epa 5b83407f62da2bef2f20a463ffc0b5d2fbf6fab388531a297d7f00627cce3300");
            heardMap.put("e-language", "English");
            heardMap.put("Content-Type", "application/json");
            heardMap.put("Accept", "application/json");
            Map params = new HashMap();
            params.put("transDetailId", transDetailId);
            params.put("refId", refId);
            String conURL = "https://payment.emoney.com.kh:8888/LASIA/trans/check";
            String senc = HttpsTool.send((new Gson()).toJson(params), heardMap, conURL, "utf-8", "utf-8", 300000, 300000, "application/json");
            return senc;
        } catch (Exception var6) {
            var6.getLocalizedMessage();
            return null;
        }
    }

    public static String billInfoPost(String paymentCode) {
        try {
            Map<String, String> heardMap = new HashMap();
            heardMap.put("Authorization", "epa 5b83407f62da2bef2f20a463ffc0b5d2fbf6fab388531a297d7f00627cce3300");
            heardMap.put("e-language", "English");
            heardMap.put("Content-Type", "application/json");
            heardMap.put("Accept", "application/json");
            Map params = new HashMap();
            params.put("paymentCode", paymentCode);
            String conURL = "https://payment.emoney.com.kh:8888/LASIA/telco/metfone-bill/info";
            String senc = HttpsTool.send((new Gson()).toJson(params), heardMap, conURL, "utf-8", "utf-8", 300000, 300000, "application/json");
            return senc;
        } catch (Exception var5) {
            var5.getLocalizedMessage();
            return null;
        }
    }



    /**
     * 查询系统我的账户余额
     *
     * @param refId
     * @param msisdn
     * @return
     */
    public static String checkMyMoneyPost(String refId, String msisdn) {
        try {
            Map<String, String> heardMap = new HashMap();
            heardMap.put("Authorization", "epa 5b83407f62da2bef2f20a463ffc0b5d2fbf6fab388531a297d7f00627cce3300");
            heardMap.put("e-language", "English");
            heardMap.put("Content-Type", "application/json");
            heardMap.put("Accept", "application/json");
            String pin = "682504|" + msisdn + "|" + refId;
            Map params = new HashMap();
            params.put("refId", refId);
            params.put("serviceType", "TOPUP");
            params.put("msisdn", msisdn);
            params.put("pin", MetfoneRSAUtils.encryptRSA(pin));
            String conURL = "https://payment.emoney.com.kh:8888/LASIA/account/balance";
            String senc = HttpsTool.send((new Gson()).toJson(params), heardMap, conURL, "utf-8", "utf-8", 300000, 300000, "application/json");
            return senc;
        } catch (Exception var7) {
            var7.getLocalizedMessage();
            return null;
        }
    }

//    public static void main(String[] args) {
//        String str = checkMyMoneyPost(getFormatedDateString(7.0F), "855886402606");
//        System.out.println(str);
//    }

    public static void main(String[] args) {
//        String phone = "0977722887";
        String phone = "0887038371";


        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String hms = sdf.format(new Date());
        ResultsModel resultsModel = sentTopUp(phone, 1, hms);
        System.out.println("充值日志：" + resultsModel.getTip());
        System.out.println("充值状态：" + resultsModel.isSuccessful());
        System.out.println("拓展字段：" + resultsModel.getExpandText());

        int i=1;
    }

    /**
     * 发起充值
     *
     * @param phone
     * @param amount
     * @param orderNum
     * @return
     */
    public static ResultsModel sentTopUp(String phone, int amount, String orderNum) {
        String tip = "";
        boolean topUpSuccess = false;

        try {
            String transDetailId = "";//可以用来复查充值订单数据
            String json = initTelPost(String.valueOf(amount), orderNum, phone);
            String tokenId = "";
            String str;
            if (!TextUtils.isEmpty(json)) {
                JsonObject object = (new JsonParser()).parse(json).getAsJsonObject();
                str = object.get("status") == null ? "" : object.get("status").getAsString();
                if (str.equals("0")) {
                    JsonObject txDetail = object.get("txDetail").getAsJsonObject();
                    if (txDetail != null) {
                        tokenId = txDetail.get("txPaymentTokenId").getAsString();
                        transDetailId = txDetail.get("transDetailId").getAsString();
                    } else {
                        tip = tip + "返回值txDetail为空";
                    }
                } else {
                    tip = tip + "initTel返回结果：" + (new Gson()).toJson(object) + " \n";
                }
            } else {
                tip = tip + "返回值为空";
            }

            String conStr = "";
            String status;
            if (!TextUtils.isEmpty(tokenId)) {
                str = MetfoneRSAUtils.decryptRSA(tokenId);
                status = str + "|" + "682504";
                tip = tip + "解析的值：" + status;
                String retStr = MetfoneRSAUtils.encryptRSA(status);
                tip = tip + "\n加密后的值：" + retStr + "\n";
                conStr = confirmPost(retStr);
            }


            //处理返回结果
            if (!TextUtils.isEmpty(conStr)) {
                //有结果返回

                System.out.println(conStr);
                JsonObject confirmObject = (new JsonParser()).parse(conStr).getAsJsonObject();
                status = confirmObject.get("status") == null ? "" : confirmObject.get("status").getAsString();
                if (status.equals("0")) {
                    System.out.println("充值成功");
                    topUpSuccess = true;
                    tip = tip + " 充值成功！！！";
                } else {
                    tip = tip + "confirmTel返回结果：" + (new Gson()).toJson(confirmObject) + " \n";
                }
            }

            return new ResultsModel(topUpSuccess, tip, transDetailId);
        } catch (Exception var13) {
            var13.printStackTrace();
            return new ResultsModel(topUpSuccess, tip);
        }
    }

    public static String getFormatedDateString(float timeZoneOffset) {
        if (timeZoneOffset > 13.0F || timeZoneOffset < -12.0F) {
            timeZoneOffset = 0.0F;
        }

        int newTime = (int) (timeZoneOffset * 60.0F * 60.0F * 1000.0F);
        String[] ids = TimeZone.getAvailableIDs(newTime);
        Object timeZone;
        if (ids.length == 0) {
            timeZone = TimeZone.getDefault();
        } else {
            timeZone = new SimpleTimeZone(newTime, ids[0]);
        }

        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sdf.setTimeZone((TimeZone) timeZone);
        return sdf.format(new Date());
    }
}
