package com.library.util.currency;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.UUID;

public class AESUtils {

    private static final String IV_STRING = "16-Bytes--String";

    /**
     * 默认的密钥
     */
    public static final String DEFAULT_KEY = "4be89b269a424036";

    /**
     * 产生随机密钥(这里产生密钥必须是16位)
     */
    public static String generateKey() {
        String key = UUID.randomUUID().toString();
        key = key.replace("-", "").substring(0, 16);// 替换掉-号
        return key;
    }
    /***
     * 
     * Description:加密
     */
    public static String encryptData(String key, String content) {
        byte[] encryptedBytes = new byte[0];
        try {
            byte[] byteContent = content.getBytes("UTF-8");
            // 注意，为了能与 iOS 统一
            // 这里的 key 不可以使用 KeyGenerator、SecureRandom、SecretKey 生成
            byte[] enCodeFormat = key.getBytes();
            SecretKeySpec secretKeySpec = new SecretKeySpec(enCodeFormat, "AES");
            byte[] initParam = IV_STRING.getBytes();
            IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);
            // 指定加密的算法、工作模式和填充方式
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec, ivParameterSpec);
            encryptedBytes = cipher.doFinal(byteContent);
            // 同样对加密后数据进行 base64 编码
            return Base64Utils.encode(encryptedBytes);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    /***解密***/
    public static String decryptData(String key, String content) throws Exception{
       
            // base64 解码
            byte[] encryptedBytes = Base64Utils.decode(content);
            byte[] enCodeFormat = key.getBytes();
            SecretKeySpec secretKey = new SecretKeySpec(enCodeFormat, "AES");
            byte[] initParam = IV_STRING.getBytes();
            IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(Cipher.DECRYPT_MODE, secretKey, ivParameterSpec);
            byte[] result = cipher.doFinal(encryptedBytes);
            return new String(result, "UTF-8");

    }

    private static final String encodePass(String pass) {
        try {
            byte messageDigest[] = null;
            MessageDigest digest = MessageDigest
                    .getInstance("MD5");
            digest.update(pass.getBytes());
            messageDigest = digest.digest();
            pass = Base64.getEncoder().encodeToString(messageDigest);
            return pass;
        } catch (Exception ex) {
            return "";
        }
    }

    public static void main(String[] args) throws Exception {
    	
		String data = AESUtils.encryptData(DEFAULT_KEY, "wcRvX9plNOAb95br0y4vVQ==");

        String PASSWORD = AESUtils.decryptData(AESUtils.DEFAULT_KEY, "i4pfK2IrI0z7vNlzQMS9MEoa/e8YQomougW3htkq08A=");
		System.out.println(data);
		System.out.println(PASSWORD);
		System.out.println(encodePass("y2np8Ndc"));
		System.out.println(encodePass2("y2np8Ndc"));
	}

    public static String encodePass2(String pass) {
        try {
            byte messageDigest[] = null;
            MessageDigest digest = MessageDigest
                    .getInstance("MD5");
            digest.update(pass.getBytes());
            messageDigest = digest.digest();
            pass = Base64.getEncoder().encodeToString(messageDigest);
            return pass;
        } catch (Exception ex) {
            return "";
        }
    }
}
