package com.library.mapper;

import com.library.model.UserModel;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 用户的Dao
 *
 * @author Administrator
 */
public interface CommMapper {

    /**
     * 通过opneid查询会员信息
     */
    public UserModel selectForOpenid(@Param("openid") String openid);

    /**
     * 查找最新的商品
     *
     * @param page
     * @param number
     * @return
     */
    public List<Map<String, Object>> findTheLatestProducts(@Param("page") int page, @Param("number") int number);

    /**
     * 查找热门商品
     *
     * @param page
     * @param number
     * @return
     */
    public List<Map<String, Object>> findPopularProducts(@Param("page") int page, @Param("number") int number);

    /**
     * 查找即将开奖商品
     *
     * @param page
     * @param number
     * @return
     */
    public List<Map<String, Object>> findUpcomingItems(@Param("page") int page, @Param("number") int number);

    /**
     * 查找已开奖的信息
     *
     * @param page
     * @param number
     * @return
     */
    public List<Map<String, Object>> findTheWinningInformation(@Param("page") int page, @Param("number") int number);

    /**
     * 中奖纪录
     *
     * @param page
     * @param number
     * @return
     */
    public List<Map<String, Object>> winningAllRecord(@Param("page") int page, @Param("number") int number);

    /**
     * 最新开奖
     *
     * @return
     */
    public List<Map<String, Object>> latestDraw();

    /**
     * 查找全部商品
     *
     * @param page
     * @param number
     * @return
     */
    public List<Map<String, Object>> findAllProducts(@Param("page") int page, @Param("number") int number);

    /**
     * 更新余额
     *
     * @return
     */
    public int updateTheBalance(@Param("map") Map<String,Object> map);

}
