var toast = new auiToast();
var state; //1表示从商品页面进入，2表示从收货地址页面进入
var id; //商品ID
var addressId; //收货地址ID
var max;

var toast = new auiToast();

$(function() {
  state = GetQueryString("state");
  id = GetQueryString("id");
  getProduct();
  if (state == 1) {
    getAddress();
  } else {
    addressId = GetQueryString("addressId");
    getIdAddress();
  }
});

/**
 * 获取用户默认收货地址
 */
function getAddress() {
  _vp.AddressOper(
    {
      type: 6
    },
    function(res) {
      if (!res.data) {
        $(".noAddress").show();
        $(".haveAddress").hide();
      } else {
        $(".haveAddress").show();
        $(".noAddress").hide();
        addressId = res.data.id;
        $("#addressName").text(res.data.user_name);
        $("#adddressPhone").text(res.data.phone);
        $("#addressWord").text(res.data.address);
      }
    }
  );
}

/**
 * 查询商品详情
 */
function getProduct() {
    toast.loading({
        title:"加载中",
        duration:2000
    })
  _vp.productDetail(
    {
      p_id: id
    },
    function(res) {
        toast.hide();
      if (res.status == 2001) {
        //需要登录
        top.location.href = "login.html";
        return;
      } else if (res.status == -1) {
        toast.fail({
          title: "系统繁忙",
          duration: 2000
        });
        return;
      }
      $("#productPic").attr("src", res.data.product_image);
      $("#productName").text(res.data.product_name);
      $("#price").text(res.data.price);
      max = res.data.need_number;
    }
  );
}

/**
 * 根据收货地址ID查询收货地址
 */
function getIdAddress() {
  _vp.AddressOper(
    {
      type: 5,
      id: addressId
    },
    function(res) {
      $(".haveAddress").show();
      $(".noAddress").hide();
      $("#addressName").text(res.data.user_name);
      $("#adddressPhone").text(res.data.phone);
      $("#addressWord").text(res.data.address);
    }
  );
}

/**
 * 前往选择收货地址
 */
function goSelectAddress() {
  window.location.href = "address-manage.html?state=2&id=" + id;
}

function submit() {
  var num = $("#num").val();
  if (!addressId) {
    toast.fail({
      title: "请选择收货地址",
      duration: 2000
    });
    return;
  }
  if (!num || !isInteger(num)) {
    toast.fail({
      title: "购买数量必须为整数",
      duration: 2000
    });
    return;
  } else if (num > max) {
    toast.fail({
      title: "购买数量不能大于" + max,
      duration: 2000
    });
    return;
  }
  _vp.participateInTheTreasure(
    {
      product_id: id,
      address_id: addressId,
      number: num
    },
    function(res) {
      if (res.status == 2001) {
        //需要登录
        top.location.href = "login.html";
        return;
      } else if (res.status == -1) {
        toast.fail({
          title: "系统繁忙",
          duration: 2000
        });
        return;
      } else if (res.status == 1) {
        toast.success({
          title: "参与成功",
          duration: 2000
        });
        setTimeout(function() {
          window.location.href = "Opencountdown.html?id=" + id;
        }, 2000);
      } else {
        toast.fail({
          title: res.msg,
          duration: 2000
        });
        return;
      }
    }
  );
}

function goBack(){
    window.location.href = 'CommodityDetails.html?id='+id;
}

//判断是否是正整数
function isInteger(obj) {
    return (obj | 0) == obj
}
