package com.library.util.currency;

import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import net.sf.json.xml.XMLSerializer;

public class JsonUtils {
	
	/**
     * 
     * @Title: excludeNull
     * @Description: 剔除空的数据
     * @return 
     * @returnType: JsonConfig
     * @author: lin
     * @date: 2017年4月22日 下午10:01:00
     */
    public static JsonConfig excludeNull(){
    	JsonConfig jsonConfig = new JsonConfig();
	    PropertyFilter filter = new PropertyFilter() {
	            public boolean apply(Object object, String fieldName, Object fieldValue) {
	            	return null == fieldValue;
	            }
	    };
	    jsonConfig.setJsonPropertyFilter(filter);
	    return jsonConfig;
    }
    
    /**
     * 
     * @Title: xmlToJson
     * @Description: xml转json
     * @param xml
     * @return
     * @returnType: JSONObject
     * @author: lin
     * @date: May 12, 2017 4:09:17 PM
     */
    public static JSONObject xmlToJson(String xml){
    	XMLSerializer xmlSerializer = new XMLSerializer();
    	return JSONObject.fromObject(xmlSerializer.read(xml));
    }
}
