/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.channel.tcp;

import com.taobao.top.link.channel.ChannelException;
import com.taobao.top.link.channel.ChannelSender;
import com.taobao.top.link.channel.netty.NettyChannelSender;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public abstract class TcpChannelSender
extends NettyChannelSender {
    public TcpChannelSender(Channel channel) {
        super(channel);
    }

    public void send(byte[] data, int offset, int length) throws ChannelException {
        this.send(ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length), null);
    }

    public void send(ByteBuffer dataBuffer, ChannelSender.SendHandler sendHandler) throws ChannelException {
        this.send(ChannelBuffers.wrappedBuffer((ByteBuffer)dataBuffer), sendHandler);
    }

    public void close(String reason) {
        this.channel.write((Object)reason).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                future.getChannel().close();
            }
        });
    }

    private void send(Object message, final ChannelSender.SendHandler sendHandler) throws ChannelException {
        if (sendHandler == null) {
            this.channel.write(message);
        } else {
            this.channel.write(message).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (sendHandler != null) {
                        sendHandler.onSendComplete(future.isSuccess());
                    }
                }
            });
        }
    }
}

