package com.library.controller;

import com.google.gson.Gson;
import com.library.TopUp.Http.HttpUtils;
import com.library.TopUp.Statel.HttpClientUtils;
import com.library.TopUp.Statel.SeatelSentUtils;
import com.library.TopUp.cellcard.CellcardSentUtils;
import com.library.respcode.ServerResponse;
import com.library.service.AdminService;
import com.library.service.CommService;
import com.library.util.QiniuUtils;
import com.wechat.pay.MD5Util;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/*
 *  @项目名：  yunVpay
 *  @包名：    com.library.controller
 *  @文件名:   CommonController
 *  @创建者:   zhouzhuo
 *  @创建时间:  2018/11/1 14:50
 *  @描述：    TODO
 */
@Controller
@RequestMapping("/Common")
public class CommonController {

    @Resource
    private CommService commService;


    //获取七牛云的token
    @ResponseBody
    @RequestMapping("/FindQNYToken")
    private ServerResponse FindQNYToken() {
        String token = QiniuUtils.getUpToken();
        return ServerResponse.createBySuccess(token);
    }

    //Recharge
    @ResponseBody
    @RequestMapping("recharge")
    private ServerResponse recharge() {
        return commService.Recharge();
    }

    //登录
    @ResponseBody
    @RequestMapping("adminLogin")
    private ServerResponse adminLogin() {
        return commService.adminLogin();
    }

    //登录
    @ResponseBody
    @RequestMapping("test")
    private ServerResponse test() {

        String json = CellcardSentUtils.getToken();
        System.out.println(json);
        return ServerResponse.createBySuccess(json);
    }

    //登录
    @ResponseBody
    @RequestMapping("test2")
    private ServerResponse test2() {

        String phone = "0189464112";
        String json = SeatelSentUtils.checkPhone(phone);
        return ServerResponse.createBySuccess(json);
    }

    //登录
    @ResponseBody
    @RequestMapping("test3")
    private ServerResponse test3() {

        String json = SeatelSentUtils.queryAgentFee();
        return ServerResponse.createBySuccess(json);
    }


    final String url = "http://172.22.188.20:11999/SeatelPayment/pay.jsp";//测试
//   public final static String url = "http://172.22.188.20:11800/SeatelPayment/pay.jsp";//生产

    final String shopid = "shoptest";
    final String private_key = "9834a62b4ec7c78a5424932bfdedfd74";
    final String terminalid = "shoptest0001";

    @ResponseBody
    @RequestMapping("test11")
    private ServerResponse test11() {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = sdf.format(new Date());

        String cmd = "queryphonenumberstatus";
        String terminaltrace = "shoptest186" + new Random().nextInt(10000);

        String phone = "0189464112";

        Map params = new HashMap();
        params.put("cmd", cmd);
        params.put("shopid", shopid);
        params.put("terminalid", terminalid);
        params.put("terminaltrace", terminaltrace);
        params.put("transtime", time);
        params.put("phone", phone);
        params.put("signtype", "MD5");

        String sign = getSignStr(cmd, terminaltrace, time, phone);
        params.put("sign", sign);

        Map<String, String> heardMap = new HashMap<>();
        heardMap.put("Content-Type", "application/json");
        heardMap.put("Accept", "application/json");


//            HttpClientResult clientResult = HttpClientUtils.doGet(url, heardMap, params);
        String json = HttpClientUtils.postWithJson(new Gson().toJson(params), url, heardMap);

        return ServerResponse.createBySuccess(json);
    }

    @ResponseBody
    @RequestMapping("test12")
    private ServerResponse test12() {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = sdf.format(new Date());

        String cmd = "queryphonenumberstatus";
        String terminaltrace = "shoptest186" + new Random().nextInt(10000);

        String phone = "0189464112";

        Map params = new HashMap();
        params.put("cmd", cmd);
        params.put("shopid", shopid);
        params.put("terminalid", terminalid);
        params.put("terminaltrace", terminaltrace);
        params.put("transtime", time);
        params.put("phone", phone);
        params.put("signtype", "MD5");

        String sign = getSignStr(cmd, terminaltrace, time, phone);
        params.put("sign", sign);

        Map<String, String> heardMap = new HashMap<>();
        heardMap.put("Content-Type", "application/json");
        heardMap.put("Accept", "application/json");


//            HttpClientResult clientResult = HttpClientUtils.doGet(url, heardMap, params);
//        String json = HttpClientUtils.postWithJson(new Gson().toJson(params), url, heardMap);

        String json = HttpUtils.post(url, params, heardMap, 30000, 30000, "utf-8");
        return ServerResponse.createBySuccess(json);
    }

    @ResponseBody
    @RequestMapping("test13")
    private ServerResponse test13() {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = sdf.format(new Date());

        String cmd = "queryphonenumberstatus";
        String terminaltrace = "shoptest186" + new Random().nextInt(10000);

        String phone = "0189464112";

        Map params = new HashMap();
        params.put("cmd", cmd);
        params.put("shopid", shopid);
        params.put("terminalid", terminalid);
        params.put("terminaltrace", terminaltrace);
        params.put("transtime", time);
        params.put("phone", phone);
        params.put("signtype", "MD5");

        String sign = getSignStr(cmd, terminaltrace, time, phone);
        params.put("sign", sign);

        Map<String, String> heardMap = new HashMap<>();
        heardMap.put("Content-Type", "application/json");
        heardMap.put("Accept", "application/json");


//            HttpClientResult clientResult = HttpClientUtils.doGet(url, heardMap, params);
//        String json = HttpClientUtils.postWithJson(new Gson().toJson(params), url, heardMap);
        String strJson = "{" +
                "\"cmd\":" + "\"" + cmd + "\"" + "," +
                "\"shopid\":" + "\"" + shopid + "\"" + "," +
                "\"terminalid\":" + "\"" + terminalid + "\"" + "," +
                "\"terminaltrace\":" + "\"" + terminaltrace + "\"" + "," +
                "\"transtime\":" + "\"" + time + "\"" + "," +
                "\"phone\":" + "\"" + phone + "\"" + "," +
                "\"signtype\":" + "\"" + "MD5" + "\"" + "," +
                "\"sign\":" + "\"" + sign + "\"" + "," +
                "}";
        String json = HttpClientUtils.postWithJson(strJson, url, heardMap);
        return ServerResponse.createBySuccess(json);
    }


    private String getSignStr(String cmd, String terminaltrace, String transtime, String phone) {

        String str = cmd + "" + shopid + terminalid + terminaltrace + transtime + phone + private_key;
        String md5Text = MD5Util.MD5Encode(str, "");
        return md5Text;
    }


}
