package com.library.TopUp.Statel;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.library.TopUp.Http.HttpUtils;
import com.library.TopUp.Http.HttpsTool;
import com.library.TopUp.model.ResultsModel;
import com.wechat.pay.MD5Util;
import org.apache.http.util.TextUtils;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class SeatelSentUtils {


    public final static String url = "http://172.22.188.20:11999/SeatelPayment/pay.jsp";//测试
//   public final static String url = "http://172.22.188.20:11800/SeatelPayment/pay.jsp";//生产

    private final static String shopid = "shoptest";
    private final static String private_key = "9834a62b4ec7c78a5424932bfdedfd74";
    private final static String terminalid = "shoptest0001";

    /**
     * 检查手机是否能充值
     *
     * @param phone
     * @return
     */
    public static String checkPhone(String phone) {

        try {

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = sdf.format(new Date());

            String cmd = "queryphonenumberstatus";
            String terminaltrace = "shoptest186" + new Random().nextInt(10000);

            Map params = new HashMap();
            params.put("cmd", cmd);
            params.put("shopid", shopid);
            params.put("terminalid", terminalid);
            params.put("terminaltrace", terminaltrace);
            params.put("transtime", time);
            params.put("phone", phone);
            params.put("signtype", "MD5");

            String sign = getSignStr(cmd, terminaltrace, time, phone);
            params.put("sign", sign);

            Map<String, String> heardMap = new HashMap<>();
            heardMap.put("Content-Type", "application/json");
            heardMap.put("Accept", "application/json");


//            HttpClientResult clientResult = HttpClientUtils.doGet(url, heardMap, params);
            String json = HttpClientUtils.postWithJson(new Gson().toJson(params), url, heardMap);

            return json;

        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 检查手机是否能充值
     *
     * @return
     */
    public static String queryAgentFee() {

        try {

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = sdf.format(new Date());

            String cmd = "queryagentfee";
            String terminaltrace = "shoptest183" + new Random().nextInt(10000);

            Map params = new HashMap();
            params.put("cmd", cmd);
            params.put("shopid", shopid);
            params.put("terminalid", terminalid);
            params.put("terminaltrace", terminaltrace);
            params.put("transtime", time);
            params.put("signtype", "MD5");

            String sign = getSignStr(cmd, terminaltrace, time, "");
            params.put("sign", sign);

            Map<String, String> heardMap = new HashMap<>();
            heardMap.put("Content-Type", "application/json");
            heardMap.put("Accept", "application/json");


//            String json = HttpUtils.post(url, params, heardMap, 10000, 10000, "utf-8");

            String json = HttpsTool.send(new Gson().toJson(params), heardMap, url, "utf-8", "utf-8",
                    10000, 10000, "application/json");
            return json;

        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }


    private static String getSignStr(String cmd, String terminaltrace, String transtime, String phone) {

        String str = cmd + "" + shopid + terminalid + terminaltrace + transtime + phone + private_key;
        String md5Text = MD5Util.MD5Encode(str, "");
        return md5Text;
    }


    public static void main(String[] args) {
        String phone = "0189464112";

        String json = checkPhone(phone);
        System.out.println(json);
//        ResultsModel resultsModel = sentTopUp(phone, 1, "99999912");
//
//        System.out.println("充值是否成功：" + resultsModel.isSuccessful());
//        System.out.println("充值日志：" + resultsModel.getTip());
    }

    /**
     * 发送Smart充值请求
     *
     * @param phone       手机号
     * @param topUpAmount 单位1美元，里面已经做了1分钱转1元的处理了
     * @param orderNum    需要确保唯一性，建议使用订单id
     */
    public static ResultsModel sentTopUp(String phone, int topUpAmount, String orderNum) {

        String tip = "";
        boolean topUpSuccess = false;

        try {

            ResultsModel resultsModel = new ResultsModel(topUpSuccess, tip);
            return resultsModel;

        } catch (Exception e) {
            e.printStackTrace();
            ResultsModel resultsModel = new ResultsModel(topUpSuccess, tip);
            return resultsModel;
        }
    }
}
