package com.wechat.refund;

import java.security.MessageDigest;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;

import com.library.config.ConfigCon;



/**
 * 用户微信退款
 * @author cyy
 *
 */
public class WeChatRefund {
	
	public static void main(String[] args) {
		wechatRefund1("131234154124",1,1);
	}
	
	/**
	 * 退款函数，该方法可以对曾经部分退款的订单进行再次退款
	 * @param out_trade_no 商户订单号
	 * @param total_fee1 退款对应的订单的总金额（以“元”为单位）
	 * @param refund_fee1 计划退款的金额（以“元”为单位）
	 * @return
	 */
	public static String wechatRefund1(String out_trade_no,double total_fee1,double refund_fee1){
		String out_refund_no = UUID.randomUUID().toString().substring(0, 32);// 退款单号，随机生成 ，但长度应该跟文档一样（32位）(卖家信息校验不一致，请核实后再试)
		int total_fee = (int) (total_fee1*100);//订单的总金额,以分为单位（填错了貌似提示：同一个out_refund_no退款金额要一致）
		int refund_fee = (int) (refund_fee1*100);;// 退款金额，以分为单位（填错了貌似提示：同一个out_refund_no退款金额要一致）
		String nonce_str = Md5(System.currentTimeMillis()+"");// 随机字符串
		
		
		//微信公众平台文档：“基本配置”--》“开发者ID”
		String appid =ConfigCon.WeChat_Appid;
		//微信公众平台文档：“基本配置”--》“开发者ID”
		String appsecret = ConfigCon.WeChat_Appid;
		//商户号
		//微信公众平台文档：“微信支付”--》“商户信息”--》“商户号”，将该值赋值给partner
		String mch_id = ConfigCon.WeChat_Mch_id;
		String op_user_id = mch_id;//就是MCHID
		//微信公众平台："微信支付"--》“商户信息”--》“微信支付商户平台”（登录）--》“API安全”--》“API密钥”--“设置密钥”（设置之后的那个值就是partnerkey，32位）
		String partnerkey = ConfigCon.WeChat_APIKey;
		SortedMap<String, String> packageParams = new TreeMap<String, String>();
		packageParams.put("appid", appid);
		packageParams.put("mch_id", mch_id);
		packageParams.put("nonce_str", nonce_str);
		packageParams.put("out_trade_no", out_trade_no);
		packageParams.put("out_refund_no", out_refund_no);
		packageParams.put("total_fee", total_fee+"");
		packageParams.put("refund_fee", refund_fee+"");
		packageParams.put("op_user_id", op_user_id);

		
		//refund_desc
	
		
		
		RequestHandler reqHandler = new RequestHandler(null, null);
		
		reqHandler.init(appid, appsecret, partnerkey);
		String sign = reqHandler.createSign(packageParams);
		
		String xml = "<xml>" + 
				"<appid>" + appid + "</appid>" + 
				"<mch_id>" + mch_id + "</mch_id>" + 
				"<nonce_str>" + nonce_str + "</nonce_str>" + 
				"<sign><![CDATA[" + sign + "]]></sign>"	+ 
				"<out_trade_no>" + out_trade_no + "</out_trade_no>"	+ 
				"<out_refund_no>" + out_refund_no + "</out_refund_no>" + 
				"<total_fee>" + total_fee + "</total_fee>" + 
				"<refund_fee>" + refund_fee + "</refund_fee>" + 
				"<op_user_id>" + op_user_id + "</op_user_id>" + 	
				"</xml>";
		
		System.out.println(xml);
		String createOrderURL = "https://api.mch.weixin.qq.com/secapi/pay/refund";
		try {
			
			String refundResult= ClientCustomSSL.doRefund(createOrderURL, xml);
			System.out.println("退款产生的json字符串："+ refundResult);
			return refundResult;
		} catch (Exception e) {
			e.printStackTrace();
			return "0";
		}
	}
	
	
	
	
	private static String Md5(String password) {
		try {
			// ʵ���ַ���
			StringBuffer buffer = new StringBuffer();
			// �����ַ���
			char[] chars = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
					'A', 'B', 'C', 'D', 'E', 'F' };
			// ������ת���ɶ���������
			byte[] bytes = password.getBytes();
			// ʹ��md5�������?
			MessageDigest md = MessageDigest.getInstance("MD5");
			// ����
			byte[] targ = md.digest(bytes);
			for (byte b : targ) {
				buffer.append(chars[(b >> 4) & 0x0F]);
				buffer.append(chars[b & 0x0F]);
			}
			return buffer.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	
}
