package com.library.util.currency;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 
 * @ClassName: TimeUtils
 * @Description: 时间工具类
 * @author: lin
 * @date: 2017年5月11日 下午3:06:18
 * @version:
 */
public class TimeUtils {
	
    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd"); 
    public static SimpleDateFormat dayFormatChina = new SimpleDateFormat("yyyy年MM月"); 
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 00:00");
    
   /**
    * 
    * @Title: getCurrentTimeString
    * @Description: 获得当前时间  格式:yyyy-MM-dd HH-mm
    * @return 
    * @returnType: String
    * @author: lin
    * @date: 2017年5月11日 下午2:17:52
    */
    public static String getCurrentTimeString(){
        return sdf.format(new Date());
    }
    
    
    /**
     * 
     * @Title: getThisMonthFirstDay
     * @Description: 获取本月第一天的日期  格式:yyyy-MM-dd
     * @return eg:2016-10-01
     * @returnType: String
     * @author: lin
     * @date: 2017年5月11日 下午2:30:25
     */
    public static String getThisMonthFirstDay(){
        Calendar c = Calendar.getInstance();    
        c.add(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH,1);//设置为1号,当前日期既为本月第一天 
        return dayFormat.format(c.getTime());
    }
    
    /**
     * 
     * @Title: getThisMonthLastDay
     * @Description: 获取本月最后一天的日期  格式:yyyy-MM-dd
     * @return eg:2016-10-31
     * @returnType: String
     * @author: lin
     * @date: 2017年5月11日 下午2:31:07
     */
    public static String getThisMonthLastDay(){
        Calendar ca = Calendar.getInstance();    
        ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));  
        return dayFormat.format(ca.getTime());
    }
    
    /**
     * 
     * @Title: getToday
     * @Description: 获取今天的日期  格式:yyyy-MM-dd
     * @return
     * @returnType: String
     * @author: lin
     * @date: 2017年5月11日 下午2:47:56
     */
    public static String getToday(){
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        return sf.format(new Date());
    }
   
    public static String getTimeByDay(Integer index){
    	 Calendar cal = Calendar.getInstance();
         cal.add(Calendar.DATE, index);
         return dayFormat.format(cal.getTime());
    }
    
    /**
     * 
     * @Title: getThreeMonthBefore
     * @Description: 获取一个月前的日期 格式:yyyy-MM-dd
     * @return
     * @returnType: String
     * @author: lin
     * @date: 2017年5月11日 下午2:49:04
     */
    public static String getThreeMonthBefore(){
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.MONTH, -1);
        return dayFormat.format(cal.getTime());
    }
    
    /**
     * 
     * @Title: getAYearBefore
     * @Description: 获取一年前的日期 格式:yyyy-MM-dd
     * @return
     * @returnType: String
     * @author: lin
     * @date: 2017年5月11日 下午2:49:27
     */
    public static String getAYearBefore(){
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.YEAR, -1);
        return dayFormat.format(cal.getTime());
    }
    
   /**
    * 
    * @Title: getCurrentTimeChina
    * @Description: 获取当前日期（带“年”、“月”、“日”）
    * @return
    * @returnType: String
    * @author: lin
    * @date: 2017年5月11日 下午3:00:20
    */
    public static String getCurrentTimeChina(){
        return dayFormatChina.format(new Date());
    }
    
    /**
     * 
     * @Title: getTimeDistance
     * @Description: 获得时间相差毫秒数
     * @param time
     * @return
     * @returnType: long
     * @author: lin
     * @date: 2017年5月11日 下午3:02:38
     */
    public static long getTimeDistance(String time) {
        long timeLong = 0;
        long curTimeLong = 0;
        try {
            timeLong = sdf.parse(time).getTime();
            curTimeLong = sdf.parse(getCurrentTimeString())
                    .getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return curTimeLong - timeLong;// 当前时间减去传入的时间
    }
    
    /**
     * 
     * @Title: getCurrentDateTimeStr
     * @Description: 获取当前时间str 格式yyyyMMddHHmmss
     * @return
     * @returnType: String
     * @author: lin
     * @date: 2017年5月11日 下午3:48:30
     */
    public static String getCurrentTimeStr()
    {
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        return dataFormat.format(date);
    }
    /****
     * 
     * Description:得到下个月当天的时间
     * @author feng
     * @date 2017年5月23日 下午3:01:07
     * @version 1.0
     * @return 2017-06-23 00:00
     */
    public static String getNextMonthTodayTime(){
    	Calendar c = Calendar.getInstance();
		c.add(Calendar.MONTH, 1);
    	return dateFormat.format(c.getTime());
    }
 /**
     * 
     * @Title: getMonthByTime
     * @Description: 获取一个日期中的月份
     * @param time 时间
     * @return 0+月份
     * @throws Exception
     * @returnType: String
     * @author: lin
     * @date: May 23, 2017 10:25:40 AM
     */
    public static String getMonthByTime(String time)throws Exception{
    	SimpleDateFormat sim=new SimpleDateFormat("yyyy-MM-dd HH:mm");
    	Date date= sim.parse(time);
    	Calendar c = Calendar.getInstance();
    	c.setTime(date);
    	String month = Integer.toString(c.get(Calendar.MONTH));
    	return "0"+month;
    }
    /***
	 * 
	 * Description:返回指定天数的日期，以当前时间为
	 * 
	 * @author feng
	 * @date 2017年4月15日 下午2:36:58
	 * @version 1.0
	 * @param date
	 *            相差的时间
	 * @param before
	 *           
	 * @return yyyy-MM-dd
	 */
	public static String getTheFirstFewDate(int date, boolean before) {
		Date newDate = new Date();
		if (before) {
			long time = newDate.getTime() + (long) (1000L * 60 * 60 * 24 * date);
			return dayFormat.format(time);
		} else {
			long time = newDate.getTime() - (long) (1000L * 60 * 60 * 24 * date);
			return dayFormat.format(time);
		}
	}
	public static String getTheFirstFewDate(String date,int num ,boolean before){
		Date newDate;
		try {
			newDate = dayFormat.parse(date);
			if (before) {
				long time = newDate.getTime() + (long) (1000L * 60 * 60 * 24 * num);
				return dayFormat.format(time);
			} else {
				long time = newDate.getTime() - (long) (1000L * 60 * 60 * 24 * num);
				return dayFormat.format(time);
			}
		} catch (ParseException e) {
			return date;
		}
		
	}
}