package com.library.util.currency;


import org.apache.commons.lang3.StringUtils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

/**
 * 
 * @ClassName: StringUtils
 * @Description: 字符串工具类
 * @author: lin
 * @date: 2017年5月11日 下午3:08:13
 * @version:
 */
public class StrUtils {

	/**
	 * MD5加密
	 * @param str
	 * @return
	 */
	public static String resutlMD5(String str) {
		String resutl = "";
		try {
			MessageDigest instance = MessageDigest.getInstance("MD5");// 获取MD5算法对象
			byte[] digest = instance.digest(str.getBytes());// 对字符串加密,返回字节数组
			StringBuffer strBuffer = new StringBuffer();
			for (byte b : digest) {
				int i = b & 0xff;
				String hexString = Integer.toHexString(i);// 将整数转为16进制
				if (hexString.length() < 2) {
					hexString = "0" + hexString;// 如果是1位的话,补0
				}
				strBuffer.append(hexString);
			}
			resutl = strBuffer.toString();
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		}
		return resutl;
	}
	
	/**
	 * 
	 * @Title: sortingStr
	 * @Description: 对字符进行排序
	 * @param str
	 * @return
	 * @returnType: String
	 * @author: lin
	 * @date: 2017年5月11日 下午3:07:56
	 */
	public static String sortingStr(String str){
		char[] arr=str.toCharArray();
		Arrays.sort(arr);
		StringBuffer buf=new StringBuffer();
		for(int i=0;i<arr.length;i++){
			buf.append(arr[i]);
		}
		return buf.toString();
	}
	
	/**
	 * 获取弹框的脚本字符串
	 * @param redirectUrl 重定向的url
	 * @return
	 */
	public static String getScriptString(String tip,String redirectUrl){
		StringBuilder sb = new StringBuilder();
		sb.append("<script type=\"text/javascript\">");
		if(StringUtils.isNotEmpty(tip)){
			sb.append("alert('" + tip +"');");
		}
		if(StringUtils.isNotEmpty(redirectUrl)){
			sb.append("location.href = '" + redirectUrl + "';");
		}
		sb.append("</script>");
		return sb.toString();
	}
	
	 /**
     * 格式化金额字符串，每三位用逗号隔开
     * @param moneyStr
     * @return
     */
    public static String formatNumberString(String moneyStr){
        moneyStr = new StringBuilder(moneyStr).reverse().toString();     //先将字符串颠倒顺序
        if(moneyStr.equals("0")){
        	return moneyStr;
        }
        String str2 = "";
        for(int i=0;i<moneyStr.length();i++){
            if(i*3+3>moneyStr.length()){
                str2 += moneyStr.substring(i*3, moneyStr.length());
                break;
            }
            str2 += moneyStr.substring(i*3, i*3+3)+",";
        }
        if(str2.endsWith(",")){
            str2 = str2.substring(0, str2.length()-1);
        }
        //最后再将顺序反转过来
        String temp = new StringBuilder(str2).reverse().toString();
        //将最后的,去掉
        return temp.substring(0, temp.lastIndexOf(",")) + temp.substring(temp.lastIndexOf(",")+1, temp.length());
    }
    
    /**
     * 
     * @Title: strIsExitArr
     * @Description: 字符串是否存在数组中
     * @param arr
     * @param name
     * @return
     * @returnType: Boolean
     * @author: lin
     * @date: May 25, 2017 2:40:04 PM
     */
    public static Boolean strIsExitArr(String[] arr,String name){
    	for(String s : arr){
    		if(s.equals(name)){
    			return true;
    		}
    	}
    	return false;
    }
}
