package com.library.util.currency;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.*;
import javax.mail.internet.*;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MailUtils {

	 /**
     * Message对象将存储我们实际发送的电子邮件信息，
     * Message对象被作为一个MimeMessage对象来创建并且需要知道应当选择哪一个JavaMail session。
     */
    private static MimeMessage message;
    
    /**
     * Session类代表JavaMail中的一个邮件会话。
     * 每一个基于JavaMail的应用程序至少有一个Session（可以有任意多的Session）。
     * 
     * JavaMail需要Properties来创建一个session对象。
     * 寻找"mail.smtp.host"    属性值就是发送邮件的主机
     * 寻找"mail.smtp.auth"    身份验证，目前免费邮件服务器都需要这一项
     */
    private static Session session;
    
    /***
     * 邮件是既可以被发送也可以被受到。JavaMail使用了两个不同的类来完成这两个功能：Transport 和 Store。 
     * Transport 是用来发送信息的，而Store用来收信。对于这的教程我们只需要用到Transport对象。
     */
    private static Transport transport;
    
    private static String mailHost;
    private static String  username;
    private static String  password;

    private static MailUtils mailUtils;
    private static Object objLock = new Object();

	private static String nickName;

	private static String debug;
    
    /**
     * 创建mailUtils实例
     * @param debug 是否开启debug打印调试信息
     * @return
     */
    public static MailUtils getInstance(){
    	if (mailUtils == null) {
			synchronized (objLock) {
				if (mailUtils == null) {
					mailUtils = new MailUtils();
					try {
						Properties properties = new Properties();
						InputStream in = MailUtils.class.getResourceAsStream("/mail.properties");
						properties.load(in);
						
						in.close();
						
						nickName = properties.getProperty("nickName");
						debug = properties.getProperty("debug");
						mailHost = properties.getProperty("mail.smtp.host");
						username = properties.getProperty("mail.sender.username");
						password = properties.getProperty("mail.sender.password");
						
						session = Session.getInstance(properties);
				        session.setDebug(debug.equals("true"));//开启后有调试信息
				        message = new MimeMessage(session);
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		}
    	
    	return mailUtils;
    }
    
   /**
    * 发送邮件
    * @param receiver 接收人
    * @param subject 主题
    * @param content 文本内容
    * @param attachment 附件，没有则填null
    * @param fileName 自定义的文件名，需要带后缀名 如：xx.mp3
    */
    public void sendMail(String receiver,String subject,String content,File attachment,String fileName){
    	try {
            // 下面这个是设置发送人的Nick name
            InternetAddress from = new InternetAddress(MimeUtility.encodeWord(nickName)+" <"+username+">");
            message.setFrom(from);
            
            // 收件人
            InternetAddress to = new InternetAddress(receiver);
            message.setRecipient(Message.RecipientType.TO, to);//还可以有CC、BCC
            
            // 邮件主题
            message.setSubject(subject);
            
            // 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
            Multipart multipart = new MimeMultipart();
            
            // 添加邮件正文
            BodyPart contentPart = new MimeBodyPart();
            contentPart.setContent(content, "text/html;charset=UTF-8");
            multipart.addBodyPart(contentPart);
            
            // 添加附件的内容
            if (attachment!=null && attachment.exists()) {
                BodyPart attachmentBodyPart = new MimeBodyPart();
                DataSource source = new FileDataSource(attachment);
                attachmentBodyPart.setDataHandler(new DataHandler(source));
                
                // 网上流传的解决文件名乱码的方法，其实用MimeUtility.encodeWord就可以很方便的搞定
                // 这里很重要，通过下面的Base64编码的转换可以保证你的中文附件标题名在发送时不会变成乱码
                //sun.misc.BASE64Encoder enc = new sun.misc.BASE64Encoder();
                //messageBodyPart.setFileName("=?GBK?B?" + enc.encode(attachment.getName().getBytes()) + "?=");
                
                //MimeUtility.encodeWord可以避免文件名乱码
                if (fileName == null || fileName == "") {
					//如果原文件名为空,使用现有文件名
                	attachmentBodyPart.setFileName(MimeUtility.encodeWord(attachment.getName()));
				}else{
					attachmentBodyPart.setFileName(MimeUtility.encodeWord(fileName));
				}
                
                multipart.addBodyPart(attachmentBodyPart);
            }
            
            // 邮件内容,也可以使纯文本"text/plain"
            message.setContent(multipart);
            
            // 保存邮件
            message.saveChanges();
            
            transport = session.getTransport("smtp");
            // smtp验证，就是你用来发邮件的邮箱用户名密码
            transport.connect(mailHost, username, password);
            // 发送
            transport.sendMessage(message, message.getAllRecipients());
            //System.out.println("send success!");
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            if(transport!=null){
                try {
                    transport.close();
                } catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
    }
    public static void main(String[] args) {
    	getInstance().sendMail("673011332@qq.com", "财务审核表格", "content", null, null);
	}
}
