package com.library.util.currency;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.*;

/**
 * Description: 模式静态文件读取
 * Company: youjiang
 * @author lin
 * @date 2016年10月14日 下午7:55:31
 * @version 1.0
 */
public class DiscountFileUtils {
	
	/**
	 * 读取文件
	 * @param fileName 文件名
	 * @return
	 * @throws Exception
	 * @author lin
	 */
	public static InputStream readFile(String fileName)throws Exception{
		return DiscountFileUtils.class.getResourceAsStream(fileName);
	}
	
	/**
	 * 读取值
	 * @param key 键
	 * @return 值
	 * @throws Exception
	 * @author lin
	 */
	public static String readProperties(String key,String fileName) throws Exception{
		Properties properties = new Properties();
		InputStream inputStream = DiscountFileUtils.readFile(fileName);
		properties.load(inputStream);
		String value = properties.getProperty(key);
		inputStream.close();
		return value;
	}

	/**
	 * 读取值
	 * @param key 键
	 * @return map 对应的key---值
	 * @throws Exception
	 * @author feng
	 */
	public static Map<String,String> readProperties(String fileName,String... keys) throws Exception{
		
		Properties properties = new Properties();
		InputStream inputStream = DiscountFileUtils.readFile(fileName);
		properties.load(inputStream);
		Map<String,String> map=new HashMap<String,String>();
		for(String key:keys){
			map.put(key,properties.getProperty(key));
		}
		inputStream.close();
		return map;
	}
	
	/**
	 * 读取文件路径
	 * @param fileName 文件名
	 * @return
	 * @throws Exception
	 * @author lin
	 */
	public static String readFilePath(String fileName)throws Exception{
		String path = DiscountFileUtils.class.getResource(fileName).getPath();
		return path.substring(1,path.length());
	}
	
	/**
	 * 修改系统状态
	 * @param key 键
	 * @param state 值 
	 * @param fileName 文件名
	 * @throws Exception
	 * @author lin
	 */
	public static void updateProperties(String key,String state,String fileName)throws Exception{
		Properties propertis = new Properties();
		InputStream inputStream = DiscountFileUtils.readFile(fileName);
		propertis.load(inputStream);
		propertis.setProperty(key, state);
		String path = DiscountFileUtils.readFilePath(fileName);
		path = "/"+path; //linux 加上"/"
		OutputStream file = new FileOutputStream(path);
		propertis.store(file,null);
		file.close();
		inputStream.close();
	} 
	
	/**
	 * 修改系统状态
	 * @param map 要设置的键值
	 * @param fileName 文件名
	 * @throws Exception
	 * @author feng
	 */
	public static void updateProperties(Map<String,String> map,String fileName)throws Exception{
		Properties propertis = new Properties();
		InputStream inputStream = DiscountFileUtils.readFile(fileName);
		propertis.load(inputStream);
		if(map!=null){
			Set<String> set = map.keySet();
			for(String it:set){
				propertis.setProperty(it, map.get(it));
			}
		}
		String path = DiscountFileUtils.readFilePath(fileName);
		path = "/"+path;
		OutputStream file = new FileOutputStream(path);
		propertis.store(file,null);
		file.close();
		inputStream.close();
	}
	
	/**
	 * 
	 * @Title: loopRead
	 * @Description: 将文件转成map
	 * @param fileName
	 * @return
	 * @throws Exception
	 * @returnType: Map<String,String>
	 * @author: lin
	 * @date: 2017年5月11日 下午3:19:35
	 */
	public static Map<String,String> loopRead(String fileName)throws Exception{
		InputStream is = DiscountFileUtils.readFile(fileName);
		Properties properties = new Properties();
		Map<String,String> map = new HashMap<String,String>();
		properties.load(is);
		Enumeration<Object> en = properties.keys();  
        while(en.hasMoreElements()){  
            String name = en.nextElement().toString();  
            String path = properties.getProperty(name);  
            map.put(name, path);  
        } 
        return map;
	}
	
	
	
}
