package com.library.util;
import java.io.IOException;
import java.sql.Timestamp;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import com.library.config.NameValue;
import com.library.respcode.ResponseCode;
import com.library.respcode.ServerResponse;

public class UrlInterceptor implements HandlerInterceptor{
	
	/** 
     * 该方法也是需要当前对应的Interceptor的preHandle方法的返回值为true时才会执行。该方法将在整个请求完成之后，也就是DispatcherServlet渲染了视图执行， 
     * 这个方法的主要作用是用于清理资源的，当然这个方法也只能在当前这个Interceptor的preHandle方法的返回值为true时才会执行。 
     */ 
	
	@Override
	public void afterCompletion(HttpServletRequest arg0,
			HttpServletResponse arg1, Object arg2, Exception arg3)
			throws Exception {
		// TODO Auto-generated method stub
		
	}

	/** 
     * 这个方法只会在当前这个Interceptor的preHandle方法返回值为true的时候才会执行。postHandle是进行处理器拦截用的，它的执行时间是在处理器进行处理之 
     * 后，也就是在Controller的方法调用之后执行，但是它会在DispatcherServlet进行视图的渲染之前执行，也就是说在这个方法中你可以对ModelAndView进行操 
     * 作。这个方法的链式结构跟正常访问的方向是相反的，也就是说先声明的Interceptor拦截器该方法反而会后调用，这跟Struts2里面的拦截器的执行过程有点像， 
     * 只是Struts2里面的intercept方法中要手动的调用ActionInvocation的invoke方法，Struts2中调用ActionInvocation的invoke方法就是调用下一个Interceptor 
     * 或者是调用action，然后要在Interceptor之前调用的内容都写在调用invoke之前，要在Interceptor之后调用的内容都写在调用invoke方法之后。 
     */  
	@Override
	public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1,
			Object arg2, ModelAndView arg3) throws Exception {
		// TODO Auto-generated method stub
		
	}
	/** 
     * preHandle方法是进行处理器拦截用的，顾名思义，该方法将在Controller处理之前进行调用，SpringMVC中的Interceptor拦截器是链式的，可以同时存在 
     * 多个Interceptor，然后SpringMVC会根据声明的前后顺序一个接一个的执行，而且所有的Interceptor中的preHandle方法都会在 
     * Controller方法调用之前调用。SpringMVC的这种Interceptor链式结构也是可以进行中断的，这种中断方式是令preHandle的返 
     * 回值为false，当preHandle的返回值为false的时候整个请求就结束了。 
     */  
	@Override
	public boolean preHandle(HttpServletRequest req, HttpServletResponse resp,
			Object arg2) throws Exception {
		String reqURL=req.getRequestURI();
		System.out.println(Tools.format3.format(new Timestamp(System.currentTimeMillis()))+" IP("+req.getRemoteAddr()+")访问的地址:"+reqURL);			
		if(!CanVisit(reqURL, req, resp)){//判断管理员是否能访问
			return false;
		}
		
		return true;
		
//		if(!CanVisit(reqURL, req)){//判断用户访问地址是否规范
//			//不符合规范访问（用户没有登录）
//			resp.getWriter().print("2001");//设置返回代码号
//			return false;
//		}else{
//			// 判断有没有访问权限
//			if (DeterMine(reqURL, req)) {// 有
//				return true;
//			} else {
//				// 没有权限
//				resp.getWriter().print("2002");// 设置返回代码号
//				return false;
//			}
//		}
	}
	
	/**
	 * 判断该用户是否拥有的访问的权限
	 * 拥有则返回true，没有返回false
	 */
	/*public boolean DeterMine(String reqURL,HttpServletRequest req){
		//1、得到用户自身拥有的权限,2、判断访问地址是否需要的权限，3、判断是否拥有该权限
		User user=(User) req.getSession().getAttribute(NameValue.User_Session);
		if(user==null){//还没有登录的用户直接放行
			return true;
		}
		if(user.getManager_not()==1){//是管理员
			return true;
		}
		
		Integer RootNumber=0;//权限代码号
		List<RootBean> list=RootName.GetRootName();
		for(int i=0;i<list.size();i++){
			RootBean bean=list.get(i);
			if(reqURL.indexOf(bean.getUrl())!=-1){//找到地址了
				RootNumber=bean.getId();//得到对应的权限代码号
			}
		}
		
		System.out.println("需要的权限："+RootNumber);
		
		if(RootNumber==0){//该访问地址不在权限地址之内
			return true;
		}else{
			//从spring里面拿出对象
			ServletContext sc = req.getSession().getServletContext();
		    XmlWebApplicationContext cxt = (XmlWebApplicationContext)WebApplicationContextUtils.getWebApplicationContext(sc);
			RoleRootDao dao=cxt.getBean(RoleRootDao.class);
			Role role=dao.GetOneRole(user.getRole_root());
			if(role==null){//查不到角色
				return false;
			}
			List<Integer> root_list=Tools.gson.fromJson(role.getRole_root(), Tools.IntegerListType);
			//判断
			if(root_list.contains(RootNumber)){//有该权限
				return true;
			}else{//没有权限
				return false;
			}
		}
	}*/
	
	/**
	 * 判断管理员访问地址是否规范：没有登录的用户不能访问除登录、注册之外的其他地址
	 * 规范：返回true，不规范：返回false
	 */
	public boolean CanVisit(String reqURL,HttpServletRequest req, HttpServletResponse resp){
		if(reqURL.indexOf("/Admin/")==-1){//不是访问管理接口
			return true;
		}
		return true;
	}

	


}
