package com.library.service.Impl;

import com.library.config.NameValue;
import com.library.mapper.AdminMapper;
import com.library.mapper.CurrencyMapper;
import com.library.model.*;
import com.library.respcode.ResponseCode;
import com.library.respcode.ServerResponse;
import com.library.service.AdminService;
import com.library.util.PictureCode;
import com.library.util.TransformationTools;
import org.apache.http.util.TextUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Service
public class AdminServiceImpl implements AdminService {
    @Resource
    private HttpServletRequest request;

    @Resource
    private CurrencyMapper currencyMapper;

    @Resource
    private AdminMapper adminMapper;

    @Override
    public ServerResponse adminOpear() {
        try {
            String type = request.getParameter("type");//1登录，2退出登录，3获取管理员信息
            if (type.equals("1")) {//
                String phone = TransformationTools.TransactSQLInjection(request.getParameter("phone"));
                String password = TransformationTools.TransactSQLInjection(request.getParameter("password"));
                String code = request.getParameter("code").toLowerCase();

//                if (!code.equals(((String) request.getSession().getAttribute("RANDOMVALIDATECODEKEY")).toLowerCase())) {
//                    return ServerResponse.createByErrorCodeMessage(2006, "验证码错误");
//                }


                List<Map<String, Object>> list = currencyMapper.FindDataListWhere(NameValue.Table_admin, 0, 1, " where phone='" + phone + "' and password='" + password + "'");
                if (list != null && list.size() > 0) {//表示有管理员，登陆成功
                    AdminModel adminModel = (AdminModel) TransformationTools.ToObjectOne(AdminModel.class, list.get(0));
                    request.getSession().setAttribute(NameValue.Admin_Session, adminModel);
                    return ServerResponse.createBySuccess();
                } else {//用户账号或者密码错误
                    return ServerResponse.createByErrorMessage("账号或者密码错误！");
                }
            } else if (type.equals("2")) {//退出登录
                request.getSession().setAttribute(NameValue.Admin_Session, null);
                return ServerResponse.createBySuccess();
            } else {//获取管理员信息
                if (request.getSession().getAttribute(NameValue.Admin_Session) == null) {
                    return ServerResponse.createByErrorCodeMessage(ResponseCode.NEED_LOGIN.getCode(), ResponseCode.NEED_LOGIN.getDesc());
                }
                AdminModel adminModel = (AdminModel) request.getSession().getAttribute(NameValue.Admin_Session);
                //获取最新的会员信息
                Map<String, Object> mapAdmin = currencyMapper.FindDataById(NameValue.Table_admin, adminModel.getId());
                adminModel = (AdminModel) TransformationTools.ToObjectOne(AdminModel.class, mapAdmin);
                request.getSession().setAttribute(NameValue.Admin_Session, adminModel);
                Map<String, Object> map = new HashMap<String, Object>();
                map.put("admin_name", adminModel.getAdmin_name());
                map.put("phone", adminModel.getAccount());
                return ServerResponse.createBySuccess(map);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return ServerResponse.createByError();
        }
    }






}
