package com.library.controller;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.library.TopUp.Http.HttpUtils;
import com.library.TopUp.Statel.HttpClientUtils;
import com.library.TopUp.Statel.SeatelSentUtils;
import com.library.TopUp.cellcard.CellcardSentUtils;
import com.library.TopUp.model.ResultsModel;
import com.library.respcode.ServerResponse;
import com.library.service.AdminService;
import com.library.service.CommService;
import com.library.util.QiniuUtils;
import com.wechat.pay.MD5Util;
import org.apache.http.util.TextUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/*
 *  @项目名：  yunVpay
 *  @包名：    com.library.controller
 *  @文件名:   CommonController
 *  @创建者:   zhouzhuo
 *  @创建时间:  2018/11/1 14:50
 *  @描述：    TODO
 */
@Controller
@RequestMapping("/Common")
public class CommonController {

    @Resource
    private CommService commService;

    @Resource
    private HttpServletRequest request;


    //检查Seatel运营商的手机
    @ResponseBody
    @RequestMapping("checkPhoneInSeatel")
    private ServerResponse checkPhoneInSeatel() {

        String phone = request.getParameter("phone");
        String json = SeatelSentUtils.checkPhone2(phone);
        return ServerResponse.createBySuccess(json);
    }

    //查询Seatel运营商剩余的余额
    @ResponseBody
    @RequestMapping("queryAgentFeeInSeatel")
    private ServerResponse queryAgentFeeInSeatel() {

        String feeJson = SeatelSentUtils.queryAgentFee();

        String tip = "";
        String myAmount = "";
        if (!TextUtils.isEmpty(feeJson)) {

            JsonParser jsonParserFee = new JsonParser();
            JsonObject jsonObjectFee = jsonParserFee.parse(feeJson).getAsJsonObject();
            String codeCheck = jsonObjectFee.get("code") == null ? "" : jsonObjectFee.get("code").getAsString();

            if (!TextUtils.isEmpty(codeCheck) && codeCheck.equals("0")) {
                //接口查询成功，比较金额大小
                if (jsonObjectFee.get("amount") != null) {
                    myAmount = jsonObjectFee.get("amount").getAsString();
                    tip += "您当前的余额为：$" + myAmount + "";
                } else {
                    tip += "获取不到余额信息";
                }
            } else {
                tip += "查询余额失败；结果为：" + feeJson;
            }
        }

        return ServerResponse.createBySuccess(tip, myAmount);
    }

    //查询Cellcard运营商剩余的余额
    @ResponseBody
    @RequestMapping("queryAgentFeeInCellcard")
    private ServerResponse queryAgentFeeInCellcard() {
        String feeJson = "";
        try {

            feeJson = CellcardSentUtils.checkBalance();

            String tip = "";
            String myAmount = "";
            if (!TextUtils.isEmpty(feeJson)) {

                JsonParser jsonParserFee = new JsonParser();
                JsonObject jsonObjectFee = jsonParserFee.parse(feeJson).getAsJsonObject();

                if (jsonObjectFee.get("data") != null) {
                    JsonObject data = jsonObjectFee.get("data").getAsJsonObject();

                    String error_message = data.get("error_message") == null ? "" : data.get("error_message").getAsString();
                    String error_code = data.get("error_code") == null ? "" : data.get("error_code").getAsString();
                    if (!TextUtils.isEmpty(error_code) && error_code.equals("0")) {
                        //接口查询成功，比较金额大小
                        if (data.get("distributor_balance") != null) {
                            myAmount = data.get("distributor_balance").getAsString();
                            tip += "您当前的余额为：$" + myAmount + "";
                            return ServerResponse.createByErrorCodeMessage(3002, tip);
                        } else {
                            tip += "获取不到余额信息;"+error_message;
                        }
                    } else {
                        tip += "查询余额失败；结果为：" + feeJson;
                    }
                } else {
                    tip += "解析data为空";
                }

            } else {
                tip += "请求的数据为空";
            }
            return ServerResponse.createByErrorCodeMessage(3001, tip);

        } catch (Exception e) {
            e.printStackTrace();
            return ServerResponse.createByErrorCodeMessage(-1, feeJson);
        }
    }


}
