/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static Logger log = Logger.getLogger(StringUtil.class.getName());
    private static char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String join(String delim, Collection<String> collections) {
        String[] values = new String[collections.size()];
        collections.toArray(values);
        return StringUtil.join(delim, 0, collections.size(), values);
    }

    public static String join(String delim, String ... strings) {
        return StringUtil.join(delim, 0, strings.length, strings);
    }

    public static String join(String delim, int start, int end, String ... strings) {
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuilder sb = new StringBuilder(strings[start]);
        for (int i = start + 1; i < end; ++i) {
            sb.append(delim).append(strings[i]);
        }
        return sb.toString();
    }

    public static void addHeader(StringBuilder sb, String key, String value) {
        sb.append(key + ": " + value + "\r\n");
    }

    public static String readLine(ByteBuffer buf) {
        boolean completed = false;
        buf.mark();
        while (buf.hasRemaining() && !completed) {
            byte b = buf.get();
            if (b != 13 || !buf.hasRemaining() || buf.get() != 10) continue;
            completed = true;
        }
        if (!completed) {
            return null;
        }
        int limit = buf.position();
        buf.reset();
        int length = limit - buf.position();
        byte[] tmp = new byte[length];
        buf.get(tmp, 0, length);
        try {
            String line = new String(tmp, "US-ASCII");
            if (log.isLoggable(Level.FINEST)) {
                log.finest(line.trim());
            }
            return line;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static StringBuilder addParam(StringBuilder sb, String key, String param) {
        sb.append(key).append("=").append(param);
        return sb;
    }

    public static StringBuilder addQuotedParam(StringBuilder sb, String key, String param) {
        sb.append(key).append("=\"").append(param).append("\"");
        return sb;
    }

    public static String toMD5HexString(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes("US-ASCII"));
            return StringUtil.toHexString(md.digest());
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }

    public static String toHexString(byte b) {
        char[] chars = new char[2];
        int d = (b & 0xF0) >> 4;
        int m = b & 0xF;
        chars[0] = hexTable[d];
        chars[1] = hexTable[m];
        return new String(chars);
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            char[] chars = new char[2];
            int d = (bytes[i] & 0xF0) >> 4;
            int m = bytes[i] & 0xF;
            chars[0] = hexTable[d];
            chars[1] = hexTable[m];
            sb.append(chars);
        }
        return sb.toString();
    }

    public static String lpad(Object str, int len, String padding) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len - str.toString().length(); ++i) {
            sb.append(padding);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String rpad(Object str, int len, String padding) {
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        for (int i = 0; i < len - str.toString().length(); ++i) {
            sb.append(padding);
        }
        return sb.toString();
    }

    public static Map<String, String> parseKeyValues(String str, char delim) {
        State state = State.KEY;
        char[] chars = str.toCharArray();
        String key = null;
        String value = null;
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>();
        boolean isQuoted = false;
        block7: for (int i = 0; i < chars.length; ++i) {
            switch (state) {
                case KEY_START: {
                    if (chars[i] == ' ') continue block7;
                    sb.append(chars[i]);
                    state = State.KEY;
                    continue block7;
                }
                case KEY: {
                    if (chars[i] == '=') {
                        key = sb.toString().trim();
                        sb = new StringBuilder();
                        state = State.VALUE_START;
                        continue block7;
                    }
                    sb.append(chars[i]);
                    continue block7;
                }
                case VALUE_START: {
                    if (chars[i] == ' ') continue block7;
                    if (chars[i] == '\"') {
                        state = State.VALUE;
                        isQuoted = true;
                        continue block7;
                    }
                    sb.append(chars[i]);
                    state = State.VALUE;
                    isQuoted = false;
                    continue block7;
                }
                case VALUE: {
                    if (isQuoted && chars[i] == '\"') {
                        state = State.DELIM;
                        value = sb.toString();
                        map.put(key, value);
                        sb = new StringBuilder();
                        continue block7;
                    }
                    if (!isQuoted && chars[i] == delim) {
                        state = State.KEY_START;
                        value = sb.toString();
                        map.put(key, value);
                        sb = new StringBuilder();
                        continue block7;
                    }
                    sb.append(chars[i]);
                    continue block7;
                }
                case DELIM: {
                    if (chars[i] == ' ' || chars[i] != ',') continue block7;
                    state = State.KEY_START;
                }
            }
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        KEY_START,
        KEY,
        VALUE_START,
        VALUE,
        DELIM;

    }
}

