/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.frame.rfc6455;

import com.taobao.top.link.embedded.websocket.frame.Frame;
import com.taobao.top.link.embedded.websocket.frame.FrameHeader;
import com.taobao.top.link.embedded.websocket.frame.Maskable;
import com.taobao.top.link.embedded.websocket.frame.rfc6455.FrameBuilderRfc6455;
import com.taobao.top.link.embedded.websocket.frame.rfc6455.FrameHeaderRfc6455;
import java.nio.ByteBuffer;
import java.util.Random;

public abstract class FrameRfc6455
extends Frame
implements Maskable {
    private boolean mask;
    private static Random random = new Random();

    protected FrameRfc6455() {
    }

    protected FrameRfc6455(FrameHeader header, byte[] bodyData) {
        super(header, bodyData);
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer headerBuffer = this.header.toByteBuffer();
        int bodyLength = 0;
        if (this.contents != null) {
            bodyLength = this.contents.length;
        }
        ByteBuffer buf = ByteBuffer.allocate(headerBuffer.limit() + bodyLength + (this.mask ? 4 : 0));
        buf.put(headerBuffer);
        if (this.mask) {
            byte[] maskkey = new byte[4];
            ByteBuffer.wrap(maskkey).putInt(random.nextInt());
            buf.put(maskkey);
            if (this.contents != null) {
                for (int i = 0; i < this.contents.length; ++i) {
                    buf.put((byte)(this.contents[i] ^ maskkey[i % 4]));
                }
            }
        } else if (this.contents != null) {
            buf.put(this.contents);
        }
        buf.flip();
        return buf;
    }

    public boolean isContinuationFrame() {
        return ((FrameHeaderRfc6455)this.header).getOpcode().equals((Object)FrameBuilderRfc6455.Opcode.CONTINUATION);
    }

    public void unmask() {
        this.mask = false;
        ((FrameHeaderRfc6455)this.header).setMask(false);
    }

    public void mask() {
        this.mask = true;
        ((FrameHeaderRfc6455)this.header).setMask(true);
    }
}

