/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.frame;

import com.taobao.top.link.embedded.websocket.frame.FrameHeader;
import java.nio.ByteBuffer;

public abstract class Frame {
    protected FrameHeader header;
    protected byte[] contents;

    protected Frame() {
    }

    protected Frame(FrameHeader header, byte[] contents) {
        this.header = header;
        this.contents = contents;
    }

    public long getContentsLength() {
        return this.header.getContentsLength();
    }

    public FrameHeader getHeader() {
        return this.header;
    }

    public abstract ByteBuffer toByteBuffer();

    public ByteBuffer getContents() {
        return ByteBuffer.wrap(this.contents);
    }

    public void readContents(byte[] buf) {
        System.arraycopy(this.contents, 0, buf, 0, buf.length);
    }

    public void readContents(byte[] buf, int offset, int length) {
        System.arraycopy(this.contents, 0, buf, offset, length);
    }

    protected void setHeader(FrameHeader header) {
        this.header = header;
    }

    protected void setContents(byte[] contents) {
        this.contents = contents;
    }
}

