/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.channel.websocket;

import com.taobao.top.link.LinkException;
import com.taobao.top.link.Logger;
import com.taobao.top.link.Text;
import com.taobao.top.link.channel.netty.NettyClientUpstreamHandler;
import com.taobao.top.link.channel.websocket.WebSocketClientChannel;
import java.nio.charset.Charset;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;

public class WebSocketClientUpstreamHandler
extends NettyClientUpstreamHandler {
    private static HttpResponseStatus SUCCESS = new HttpResponseStatus(101, "Web Socket Protocol Handshake");
    protected WebSocketClientHandshaker handshaker;

    public WebSocketClientUpstreamHandler(Logger logger, WebSocketClientChannel clientChannel) {
        super(logger, clientChannel);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!this.handshaker.isHandshakeComplete()) {
            this.handleHandshake(ctx, (HttpResponse)e.getMessage());
        }
        if (e.getMessage() instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)e.getMessage());
        }
    }

    private void handleHandshake(ChannelHandlerContext ctx, HttpResponse response) throws Exception {
        boolean validConnection;
        this.dump(response);
        boolean validStatus = response.getStatus().equals((Object)SUCCESS);
        boolean validUpgrade = response.getHeader("Upgrade") != null && response.getHeader("Upgrade").equalsIgnoreCase("WebSocket");
        boolean bl = validConnection = response.getHeader("Connection") != null && response.getHeader("Connection").equalsIgnoreCase("Upgrade");
        if (!(validStatus && validUpgrade && validConnection)) {
            throw new LinkException(response.getStatus().getCode(), String.format(Text.WS_HANDSHAKE_INVALID, response.getContent().readable() ? response.getContent().toString(Charset.forName("UTF-8")) : ""));
        }
        this.handshaker.finishHandshake(ctx.getChannel(), response);
        if (this.haveHandler()) {
            this.getHandler().onConnect(this.createContext(response));
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof CloseWebSocketFrame) {
            Object[] objectArray = new Object[2];
            objectArray[0] = ((CloseWebSocketFrame)frame).getStatusCode();
            this.closedReason = ((CloseWebSocketFrame)frame).getReasonText();
            objectArray[1] = this.closedReason;
            this.logger.info(Text.WS_CONNECTION_CLOSED_BY, objectArray);
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
            this.clear(ctx);
            this.logger.warn(Text.WS_CONNECTION_CLOSED_BY, closeFrame.getStatusCode(), closeFrame.getReasonText());
        } else if (frame instanceof BinaryWebSocketFrame) {
            if (!((BinaryWebSocketFrame)frame).isFinalFragment()) {
                this.logger.warn(Text.WS_NOT_FINAL);
                return;
            }
            if (this.haveHandler()) {
                ChannelBuffer buffer = ((BinaryWebSocketFrame)frame).getBinaryData();
                this.getHandler().onMessage(this.createContext(buffer.toByteBuffer()));
            }
        }
    }

    private void dump(HttpResponse response) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug("%s|%s", response.getStatus().getCode(), response.getStatus().getReasonPhrase());
        for (Map.Entry h : response.getHeaders()) {
            this.logger.debug("%s=%s", h.getKey(), h.getValue());
        }
    }

    public static interface ClearHandler {
        public void clear();
    }
}

