/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.common;

import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.common.ZoneReqInfo;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class AutoZone
extends Zone {
    static AutoZone instance = new AutoZone();
    private final String ucServer;
    private Map<ZoneIndex, ZoneInfo> zones = new ConcurrentHashMap<ZoneIndex, ZoneInfo>();
    private Client client;

    AutoZone() {
        this("https://uc.qbox.me");
    }

    AutoZone(String ucServer) {
        this.ucServer = ucServer;
        this.client = new Client();
    }

    private UCRet getZoneJson(ZoneIndex index) throws QiniuException {
        String address = this.ucServer + "/v1/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        Response r = this.client.get(address);
        return r.jsonToObject(UCRet.class);
    }

    ZoneInfo zoneInfo(String ak, String bucket) throws QiniuException {
        ZoneIndex index = new ZoneIndex(ak, bucket);
        ZoneInfo info = this.zones.get(index);
        if (info == null) {
            UCRet ret = this.getZoneJson(index);
            try {
                info = ZoneInfo.buildFromUcRet(ret);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (info != null) {
                this.zones.put(index, info);
            }
        }
        return info;
    }

    ZoneInfo queryByToken(ZoneReqInfo ab) {
        try {
            return this.zoneInfo(ab.ak, ab.bucket);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getUpHttp(ZoneReqInfo ab) {
        ZoneInfo info = this.queryByToken(ab);
        if (info == null) {
            return "";
        }
        return info.upHttp;
    }

    @Override
    public String getUpBackupHttp(ZoneReqInfo ab) {
        ZoneInfo info = this.queryByToken(ab);
        if (info == null) {
            return "";
        }
        return info.upBackupHttp;
    }

    @Override
    public String getUpIpHttp(ZoneReqInfo ab) {
        ZoneInfo info = this.queryByToken(ab);
        if (info == null) {
            return "";
        }
        return info.upIpHttp;
    }

    @Override
    public String getIovipHttp(ZoneReqInfo ab) {
        ZoneInfo info = this.queryByToken(ab);
        if (info == null) {
            return "";
        }
        return info.iovipHttp;
    }

    @Override
    public String getUpHttps(ZoneReqInfo ab) {
        ZoneInfo info = this.queryByToken(ab);
        if (info == null) {
            return "";
        }
        return info.upHttps;
    }

    @Override
    public String getUpBackupHttps(ZoneReqInfo ab) {
        ZoneInfo info = this.queryByToken(ab);
        if (info == null) {
            return "";
        }
        return info.upBackupHttps;
    }

    @Override
    public String getUpIpHttps(ZoneReqInfo ab) {
        ZoneInfo info = this.queryByToken(ab);
        if (info == null) {
            return "";
        }
        return info.upIpHttps;
    }

    @Override
    public String getIovipHttps(ZoneReqInfo ab) {
        ZoneInfo info = this.queryByToken(ab);
        if (info == null) {
            return "";
        }
        return info.iovipHttps;
    }

    private class UCRet {
        Map<String, List<String>> http;
        Map<String, List<String>> https;

        private UCRet() {
        }
    }

    private static class ZoneIndex {
        private final String accessKey;
        private final String bucket;

        ZoneIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof ZoneIndex && ((ZoneIndex)obj).accessKey.equals(this.accessKey) && ((ZoneIndex)obj).bucket.equals(this.bucket);
        }
    }

    static class ZoneInfo {
        final String upHttp;
        final String upBackupHttp;
        final String upIpHttp;
        final String iovipHttp;
        final String upHttps;
        final String upBackupHttps;
        final String upIpHttps;
        final String iovipHttps;

        private ZoneInfo(String upHttp, String upBackupHttp, String upIpHttp, String iovipHttp, String upHttps, String upBackupHttps, String upIpHttps, String iovipHttps) {
            this.upHttp = upHttp;
            this.upBackupHttp = upBackupHttp;
            this.upIpHttp = upIpHttp;
            this.iovipHttp = iovipHttp;
            this.upHttps = upHttps;
            this.upBackupHttps = upBackupHttps;
            this.upIpHttps = upIpHttps;
            this.iovipHttps = iovipHttps;
        }

        static ZoneInfo buildFromUcRet(UCRet ret) {
            String upHttps;
            List<String> upsHttp = ret.http.get("up");
            String upHttp = upsHttp.get(0);
            String upBackupHttp = upsHttp.get(1);
            String upIpHttp = upsHttp.get(2).split(" ")[2].split("//")[1];
            String ioHttp = ret.http.get("io").get(0);
            List<String> upsHttps = ret.https.get("up");
            String upBackupHttps = upHttps = upsHttps.get(0);
            String upIpHttps = "";
            if (upsHttps.size() > 1) {
                upBackupHttps = upsHttps.get(1);
            }
            if (upsHttps.size() > 2) {
                upIpHttps = upsHttps.get(2).split(" ")[2].split("//")[1];
            }
            String ioHttps = ret.https.get("io").get(0);
            return new ZoneInfo(upHttp, upBackupHttp, upIpHttp, ioHttp, upHttps, upBackupHttps, upIpHttps, ioHttps);
        }
    }
}

