package com.library.controller;

import com.library.TopUp.cellcard.CellcardSentUtils;
import com.library.respcode.ServerResponse;
import com.library.service.AdminService;
import com.library.service.CommService;
import com.library.util.QiniuUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;

/*
 *  @项目名：  yunVpay
 *  @包名：    com.library.controller
 *  @文件名:   CommonController
 *  @创建者:   zhouzhuo
 *  @创建时间:  2018/11/1 14:50
 *  @描述：    TODO
 */
@Controller
@RequestMapping("/Common")
public class CommonController {

    @Resource
    private CommService commService;


    //获取七牛云的token
    @ResponseBody
    @RequestMapping("/FindQNYToken")
    private ServerResponse FindQNYToken() {
        String token = QiniuUtils.getUpToken();
        return ServerResponse.createBySuccess(token);
    }

    //Recharge
    @ResponseBody
    @RequestMapping("recharge")
    private ServerResponse recharge() {
        return commService.Recharge();
    }

    //登录
    @ResponseBody
    @RequestMapping("adminLogin")
    private ServerResponse adminLogin() {
        return commService.adminLogin();
    }

    //登录
    @ResponseBody
    @RequestMapping("test")
    private ServerResponse test() {

        String json = CellcardSentUtils.getToken();
        System.out.println(json);
        return ServerResponse.createBySuccess(json);
    }

}
