/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.Node;
import com.hp.hpl.sparta.NodeListWithPosition;
import com.hp.hpl.sparta.Text;
import com.hp.hpl.sparta.xpath.AllElementTest;
import com.hp.hpl.sparta.xpath.AttrEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrExistsExpr;
import com.hp.hpl.sparta.xpath.AttrGreaterExpr;
import com.hp.hpl.sparta.xpath.AttrLessExpr;
import com.hp.hpl.sparta.xpath.AttrNotEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrTest;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.ElementTest;
import com.hp.hpl.sparta.xpath.ParentNodeTest;
import com.hp.hpl.sparta.xpath.PositionEqualsExpr;
import com.hp.hpl.sparta.xpath.Step;
import com.hp.hpl.sparta.xpath.TextEqualsExpr;
import com.hp.hpl.sparta.xpath.TextExistsExpr;
import com.hp.hpl.sparta.xpath.TextNotEqualsExpr;
import com.hp.hpl.sparta.xpath.TextTest;
import com.hp.hpl.sparta.xpath.ThisNodeTest;
import com.hp.hpl.sparta.xpath.TrueExpr;
import com.hp.hpl.sparta.xpath.Visitor;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.util.Enumeration;
import java.util.Vector;

class XPathVisitor
implements Visitor {
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    private final NodeListWithPosition nodelistRaw_ = new NodeListWithPosition();
    private Vector nodelistFiltered_ = new Vector();
    private Enumeration nodesetIterator_ = null;
    private Object node_ = null;
    private final BooleanStack exprStack_ = new BooleanStack();
    private Node contextNode_;
    private boolean multiLevel_;
    private XPath xpath_;

    private XPathVisitor(XPath xPath, Node node) throws XPathException {
        this.xpath_ = xPath;
        this.contextNode_ = node;
        this.nodelistFiltered_ = new Vector(1);
        this.nodelistFiltered_.addElement(this.contextNode_);
        Enumeration enumeration = xPath.getSteps();
        while (enumeration.hasMoreElements()) {
            Step step = (Step)enumeration.nextElement();
            this.multiLevel_ = step.isMultiLevel();
            this.nodesetIterator_ = null;
            step.getNodeTest().accept(this);
            this.nodesetIterator_ = this.nodelistRaw_.iterator();
            this.nodelistFiltered_.removeAllElements();
            BooleanExpr booleanExpr = step.getPredicate();
            while (this.nodesetIterator_.hasMoreElements()) {
                this.node_ = this.nodesetIterator_.nextElement();
                booleanExpr.accept(this);
                Boolean bl = this.exprStack_.pop();
                if (!bl.booleanValue()) continue;
                this.nodelistFiltered_.addElement(this.node_);
            }
        }
    }

    public XPathVisitor(Element element, XPath xPath) throws XPathException {
        this(xPath, element);
        if (xPath.isAbsolute()) {
            throw new XPathException(xPath, "Cannot use element as context node for absolute xpath");
        }
    }

    public XPathVisitor(Document document, XPath xPath) throws XPathException {
        this(xPath, document);
    }

    public void visit(ThisNodeTest thisNodeTest) {
        this.nodelistRaw_.removeAllElements();
        this.nodelistRaw_.add(this.contextNode_, 1);
    }

    public void visit(ParentNodeTest parentNodeTest) throws XPathException {
        this.nodelistRaw_.removeAllElements();
        Element element = this.contextNode_.getParentNode();
        if (element == null) {
            throw new XPathException(this.xpath_, "Illegal attempt to apply \"..\" to node with no parent.");
        }
        this.nodelistRaw_.add(element, 1);
    }

    public void visit(AllElementTest allElementTest) {
        Vector vector = this.nodelistFiltered_;
        this.nodelistRaw_.removeAllElements();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof Element) {
                this.accumulateElements((Element)e);
                continue;
            }
            if (!(e instanceof Document)) continue;
            this.accumulateElements((Document)e);
        }
    }

    private void accumulateElements(Document document) {
        Element element = document.getDocumentElement();
        this.nodelistRaw_.add(element, 1);
        if (this.multiLevel_) {
            this.accumulateElements(element);
        }
    }

    private void accumulateElements(Element element) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                this.nodelistRaw_.add(node, ++n);
                if (this.multiLevel_) {
                    this.accumulateElements((Element)node);
                }
            }
            node = node.getNextSibling();
        }
    }

    public void visit(TextTest textTest) {
        Vector vector = this.nodelistFiltered_;
        this.nodelistRaw_.removeAllElements();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Element)) continue;
            Element element = (Element)e;
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Text) {
                    this.nodelistRaw_.add(((Text)node).getData());
                }
                node = node.getNextSibling();
            }
        }
    }

    public void visit(ElementTest elementTest) {
        String string = elementTest.getTagName();
        Vector vector = this.nodelistFiltered_;
        int n = vector.size();
        this.nodelistRaw_.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            if (e instanceof Element) {
                this.accumulateMatchingElements((Element)e, string);
            } else if (e instanceof Document) {
                this.accumulateMatchingElements((Document)e, string);
            }
            ++n2;
        }
    }

    private void accumulateMatchingElements(Document document, String string) {
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        if (element.getTagName() == string) {
            this.nodelistRaw_.add(element, 1);
        }
        if (this.multiLevel_) {
            this.accumulateMatchingElements(element, string);
        }
    }

    private void accumulateMatchingElements(Element element, String string) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (element2.getTagName() == string) {
                    this.nodelistRaw_.add(element2, ++n);
                }
                if (this.multiLevel_) {
                    this.accumulateMatchingElements(element2, string);
                }
            }
            node = node.getNextSibling();
        }
    }

    public void visit(AttrTest attrTest) {
        Vector vector = this.nodelistFiltered_;
        this.nodelistRaw_.removeAllElements();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Element element;
            String string;
            Node node = (Node)enumeration.nextElement();
            if (!(node instanceof Element) || (string = (element = (Element)node).getAttribute(attrTest.getAttrName())) == null) continue;
            this.nodelistRaw_.add(string);
        }
    }

    public void visit(TrueExpr trueExpr) {
        this.exprStack_.push(TRUE);
    }

    public void visit(AttrExistsExpr attrExistsExpr) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        String string = element.getAttribute(attrExistsExpr.getAttrName());
        boolean bl = string != null && string.length() > 0;
        this.exprStack_.push(bl ? TRUE : FALSE);
    }

    public void visit(AttrEqualsExpr attrEqualsExpr) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        String string = element.getAttribute(attrEqualsExpr.getAttrName());
        boolean bl = attrEqualsExpr.getAttrValue().equals(string);
        this.exprStack_.push(bl ? TRUE : FALSE);
    }

    public void visit(AttrNotEqualsExpr attrNotEqualsExpr) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        String string = element.getAttribute(attrNotEqualsExpr.getAttrName());
        boolean bl = !attrNotEqualsExpr.getAttrValue().equals(string);
        this.exprStack_.push(bl ? TRUE : FALSE);
    }

    public void visit(AttrLessExpr attrLessExpr) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        long l = Long.parseLong(element.getAttribute(attrLessExpr.getAttrName()));
        boolean bl = (double)l < attrLessExpr.getAttrValue();
        this.exprStack_.push(bl ? TRUE : FALSE);
    }

    public void visit(AttrGreaterExpr attrGreaterExpr) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        long l = Long.parseLong(element.getAttribute(attrGreaterExpr.getAttrName()));
        boolean bl = (double)l > attrGreaterExpr.getAttrValue();
        this.exprStack_.push(bl ? TRUE : FALSE);
    }

    public void visit(TextExistsExpr textExistsExpr) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Text) {
                this.exprStack_.push(TRUE);
                return;
            }
            node = node.getNextSibling();
        }
        this.exprStack_.push(FALSE);
    }

    public void visit(TextEqualsExpr textEqualsExpr) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        Node node = element.getFirstChild();
        while (node != null) {
            Text text;
            if (node instanceof Text && (text = (Text)node).getData().equals(textEqualsExpr.getValue())) {
                this.exprStack_.push(TRUE);
                return;
            }
            node = node.getNextSibling();
        }
        this.exprStack_.push(FALSE);
    }

    public void visit(TextNotEqualsExpr textNotEqualsExpr) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        Node node = element.getFirstChild();
        while (node != null) {
            Text text;
            if (node instanceof Text && !(text = (Text)node).getData().equals(textNotEqualsExpr.getValue())) {
                this.exprStack_.push(TRUE);
                return;
            }
            node = node.getNextSibling();
        }
        this.exprStack_.push(FALSE);
    }

    public void visit(PositionEqualsExpr positionEqualsExpr) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test position of document");
        }
        Element element = (Element)this.node_;
        boolean bl = this.nodelistRaw_.position(element) == positionEqualsExpr.getPosition();
        this.exprStack_.push(bl ? TRUE : FALSE);
    }

    public Enumeration getResultEnumeration() {
        return this.nodelistFiltered_.elements();
    }

    public Element getFirstResultElement() {
        return this.nodelistFiltered_.size() == 0 ? null : (Element)this.nodelistFiltered_.elementAt(0);
    }

    public String getFirstResultString() {
        return this.nodelistFiltered_.size() == 0 ? null : this.nodelistFiltered_.elementAt(0).toString();
    }

    private static class BooleanStack {
        private Item top_ = null;

        private BooleanStack() {
        }

        void push(Boolean bl) {
            this.top_ = new Item(bl, this.top_);
        }

        Boolean pop() {
            Boolean bl = this.top_.bool;
            this.top_ = this.top_.prev;
            return bl;
        }

        private static class Item {
            final Boolean bool;
            final Item prev;

            Item(Boolean bl, Item item) {
                this.bool = bl;
                this.prev = item;
            }
        }
    }
}

