/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.loader;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultLoader {
    protected final Configuration configuration;
    protected final Executor executor;
    protected final MappedStatement mappedStatement;
    protected final Object parameterObject;
    protected final Class<?> targetType;
    protected final ObjectFactory objectFactory;
    protected final CacheKey cacheKey;
    protected final BoundSql boundSql;
    protected boolean loaded;
    protected Object resultObject;

    public ResultLoader(Configuration config, Executor executor, MappedStatement mappedStatement, Object parameterObject, Class<?> targetType, CacheKey cacheKey, BoundSql boundSql) {
        this.configuration = config;
        this.executor = executor;
        this.mappedStatement = mappedStatement;
        this.parameterObject = parameterObject;
        this.targetType = targetType;
        this.objectFactory = this.configuration.getObjectFactory();
        this.cacheKey = cacheKey;
        this.boundSql = boundSql;
    }

    public Object loadResult() throws SQLException {
        List list = this.selectList();
        if (this.targetType != null && this.targetType.isAssignableFrom(list.getClass())) {
            this.resultObject = list;
        } else if (this.targetType != null && this.objectFactory.isCollection(this.targetType)) {
            this.resultObject = this.objectFactory.create(this.targetType);
            MetaObject metaObject = this.configuration.newMetaObject(this.resultObject);
            metaObject.addAll(list);
        } else if (this.targetType != null && this.targetType.isArray()) {
            Object[] array = (Object[])Array.newInstance(this.targetType.getComponentType(), list.size());
            this.resultObject = list.toArray(array);
        } else {
            if (list.size() > 1) {
                throw new ExecutorException("Statement " + this.mappedStatement.getId() + " returned more than one row, where no more than one was expected.");
            }
            if (list.size() == 1) {
                this.resultObject = list.get(0);
            }
        }
        return this.resultObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> List<E> selectList() throws SQLException {
        Executor localExecutor = this.executor;
        if (localExecutor.isClosed()) {
            localExecutor = this.newExecutor();
        }
        try {
            List list = localExecutor.query(this.mappedStatement, this.parameterObject, RowBounds.DEFAULT, Executor.NO_RESULT_HANDLER, this.cacheKey, this.boundSql);
            return list;
        }
        finally {
            if (localExecutor != this.executor) {
                localExecutor.close(false);
            }
        }
    }

    private Executor newExecutor() throws SQLException {
        Environment environment = this.configuration.getEnvironment();
        if (environment == null) {
            throw new ExecutorException("ResultLoader could not load lazily.  Environment was not configured.");
        }
        DataSource ds = environment.getDataSource();
        if (ds == null) {
            throw new ExecutorException("ResultLoader could not load lazily.  DataSource was not configured.");
        }
        TransactionFactory transactionFactory = environment.getTransactionFactory();
        Transaction tx = transactionFactory.newTransaction(ds, null, false);
        return this.configuration.newExecutor(tx, ExecutorType.SIMPLE);
    }

    public boolean wasNull() {
        return this.resultObject == null;
    }
}

