/*
 * Copyright 2019-2029 geekidea(https://github.com/geekidea)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sien.common.vo.app;

import io.geekidea.springbootplus.framework.shiro.service.LoginToken;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author geekidea
 * @date 2019-10-26
 **/
@Data
@Accessors(chain = true)
@ApiModel("登录用户信息LoginAppUserTokenVo")
public class LoginAppUserTokenVo implements LoginToken {

    @ApiModelProperty("token")
    private String token;

    @ApiModelProperty("主键")
    private Long id;

//    @ApiModelProperty("用户名")
//    private String username;

    @ApiModelProperty("是否已经注册, true = 已经注册, false = 没有注册")
    private Boolean hasRegister;

    @ApiModelProperty("姓")
    private String surname;

    @ApiModelProperty("名")
    private String name;

    @ApiModelProperty("公司名")
    private String companyName;

    @ApiModelProperty("微信号")
    private String wechat;

    @ApiModelProperty("出生日期")
    private String dateOfBirth;

//    @ApiModelProperty("昵称")
//    private String nickname;

    @ApiModelProperty("手机号码")
    private String phone;

    @ApiModelProperty("手机区号")
    private String phoneArea;

    @ApiModelProperty("性别，0：女，1：男，默认1")
    private Integer gender;

    @ApiModelProperty("头像")
    private String head;
}
