package com.sien.common.param;

import com.sien.common.entity.base.ImgJson;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 包机介绍
 *
 * @author giao
 * @since 2020-10-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "CharterIntroductionUpdateParam")
public class CharterIntroductionUpdateParam extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("包机图片url")
    private List<ImgJson> imgList;

    @ApiModelProperty(value = "包机文字")
    private String text;

    @ApiModelProperty("包机标题")
    private String title;

    @ApiModelProperty("类型 1私人;2团体;3货运;4医疗")
    private Integer type;

}
