package com.sien.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.sien.common.entity.DonationAgent;
import com.sien.common.param.DonationAgentPageParam;
import com.sien.common.param.DonationAgentQueryVo;

import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;

/**
 * 替他人捐款记录表 Mapper 接口
 *
 * @author hewei
 * @since 2021-02-25
 */
@Repository
public interface DonationAgentMapper extends BaseMapper<DonationAgent> {

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             */
        DonationAgentQueryVo getDonationAgentById(Serializable id);

            /**
             * 获取分页对象
             *
             * @param page
             * @param donationAgentPageParam
             * @return
             */
            IPage<DonationAgentQueryVo> getDonationAgentPageList(@Param("page") Page page,@Param("param") DonationAgentPageParam donationAgentPageParam);

        }
