package com.sien.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sien.common.entity.AppUser;
import com.sien.common.entity.BusinessPlain;
import com.sien.common.param.AppUserPageParam;
import com.sien.common.param.BusinessPlainPageParam;
import com.sien.common.vo.AppUserQueryVo;
import com.sien.common.vo.BusinessPlainQueryForAppVo;
import com.sien.common.vo.BusinessPlainQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 公务机出售/托管表 Mapper 接口
 *
 * @author giao
 * @since 2020-10-14
 */
@Repository
public interface BusinessPlainMapper extends BaseMapper<BusinessPlain> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    BusinessPlainQueryVo getBusinessPlainById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param businessPlainPageParam
     * @param mcId
     * @return
     */
    IPage<BusinessPlainQueryVo> getBusinessPlainPageList(
            @Param("page") Page page, @Param("param") BusinessPlainPageParam businessPlainPageParam,@Param("mcId") Long mcId);


    IPage<BusinessPlainQueryForAppVo> getBusinessPlainPageListForApp(@Param("page") Page page, @Param("param") BusinessPlainPageParam businessPlainPageParam);

    /**
     * APP用户 Mapper 接口
     *
     * @author wei
     * @since 2020-09-23
     */
    @Repository
    interface AppUserMapper extends BaseMapper<AppUser> {

        /**
         * 根据ID获取查询对象
         *
         * @param id
         * @return
         */
        AppUserQueryVo getAppUserById(Serializable id);

        /**
         * 获取分页对象
         *
         * @param page
         * @param appUserPageParam
         * @return
         */
        IPage<AppUserQueryVo> getAppUserPageList(@Param("page") Page page, @Param("param") AppUserPageParam appUserPageParam);

    }
}
