package com.sien.common.service;

import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.sien.common.entity.VipRecord;
import com.sien.common.param.VipOpenParam;
import com.sien.common.param.VipRecordPageParam;
import com.sien.common.vo.VipRecordQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * Vip开通记录 服务类
 *
 * @author hewei
 * @since 2021-02-25
 */
public interface VipRecordService extends BaseService<VipRecord> {

        /**
         * 支付回调
         * @param xmlData
         * @return
         */
        String vipOrderNotifyResult(String xmlData);

        /**
         * 保存
         *
         * @param vipRecord
         * @return
         * @throws Exception
         */
        boolean saveVipRecord(VipRecord vipRecord)throws Exception;

        /**
         * 开通vip
         *
         * @param vipOpenParam
         * @return
         * @throws Exception
         */
        ApiResult<WxPayMpOrderResult> openVip(VipOpenParam vipOpenParam) throws Exception;

        /**
         * 修改
         *
         * @param vipRecord
         * @return
         * @throws Exception
         */
        boolean updateVipRecord(VipRecord vipRecord)throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteVipRecord(Long id)throws Exception;

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             * @throws Exception
             */
        VipRecordQueryVo getVipRecordById(Long id)throws Exception;

        /**
         * 获取分页对象
         *
         * @param vipRecordPageParam
         * @return
         * @throws Exception
         */
        Paging<VipRecordQueryVo> getVipRecordPageList(VipRecordPageParam vipRecordPageParam) throws Exception;

        }
