package com.sien.common.factory;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author: JJww
 * @Date:2020/11/5
 */
@Component
public class PushFactory {

    @Autowired
    private PushService umengIosPushServiceImpl;

    @Autowired
    private PushService umengAndroidPushServiceImpl;

    /**
     * 创建对应实现类
     *
     * @param type
     * @return
     */
    public PushService getService(Integer type) {
        switch (type) {
            case 1:
                return umengAndroidPushServiceImpl;
            case 2:
                return umengIosPushServiceImpl;
            default:
                return null;
        }
    }

}
