package com.sien.common.controller;

import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.sien.common.param.VipOpenParam;
import com.sien.common.service.VipRecordService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Vip开通记录 控制器
 *
 * @author hewei
 * @since 2021-02-25
 */
@Slf4j
@RestController
@RequestMapping("/vipRecord")
@Api(value = "Vip开通API", tags = {"Vip开通"})
public class VipRecordController extends BaseController {

    @Autowired
    private VipRecordService vipRecordService;


    /**
     * Vip开通
     */
    @PostMapping("/open")
    @OperationLog(name = "开通Vip", type = OperationLogType.ADD)
    @ApiOperation(value = "开通Vip")
    public ApiResult<WxPayMpOrderResult> openVip(@Validated(Add.class) @RequestBody VipOpenParam vipOpenParam) throws Exception {

        return vipRecordService.openVip(vipOpenParam);
    }

//    /**
//     * 添加Vip开通记录
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加Vip开通记录", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加Vip开通记录")
//    public ApiResult<Boolean> addVipRecord(@Validated(Add.class) @RequestBody VipRecord vipRecord)throws Exception{
//            boolean flag= vipRecordService.saveVipRecord(vipRecord);
//            return ApiResult.result(flag);
//            }
//
//    /**
//     * 修改Vip开通记录
//     */
//    @PostMapping("/update")
//        @OperationLog(name = "修改Vip开通记录", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改Vip开通记录")
//    public ApiResult<Boolean> updateVipRecord(@Validated(Update.class) @RequestBody VipRecord vipRecord)throws Exception{
//            boolean flag= vipRecordService.updateVipRecord(vipRecord);
//            return ApiResult.result(flag);
//            }
//
//    /**
//     * 删除Vip开通记录
//     */
//    @PostMapping("/delete/{id}")
//        @OperationLog(name = "删除Vip开通记录", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除Vip开通记录")
//    public ApiResult<Boolean> deleteVipRecord(@PathVariable("id") Long id)throws Exception{
//            boolean flag= vipRecordService.deleteVipRecord(id);
//            return ApiResult.result(flag);
//            }
//
//    /**
//     * 获取Vip开通记录详情
//     */
//    @GetMapping("/info/{id}")
//        @OperationLog(name = "Vip开通记录详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "Vip开通记录详情")
//    public ApiResult<VipRecordQueryVo> getVipRecord(@PathVariable("id") Long id)throws Exception{
//            VipRecordQueryVo vipRecordQueryVo = vipRecordService.getVipRecordById(id);
//            return ApiResult.ok(vipRecordQueryVo);
//            }
//
//    /**
//     * Vip开通记录分页列表
//     */
//    @PostMapping("/getPageList")
//        @OperationLog(name = "Vip开通记录分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "Vip开通记录分页列表")
//    public ApiResult<Paging<VipRecordQueryVo>>getVipRecordPageList(@Validated @RequestBody VipRecordPageParam vipRecordPageParam)throws Exception{
//            Paging<VipRecordQueryVo> paging = vipRecordService.getVipRecordPageList(vipRecordPageParam);
//            return ApiResult.ok(paging);
//    }

}

