package io.geekidea.springbootplus.test;

import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * 微信支付测试
 */
@RunWith(SpringRunner.class)
@SpringBootTest
public class WxPayTest {

    @Autowired
    private WxPayService wxService;


    /**
     * 调用统一下单接口，并组装生成支付所需参数对象.
     *
     * @param request 统一下单请求参数
     * @param <T>     请使用{@link com.github.binarywang.wxpay.bean.order}包下的类
     * @return 返回 {@link com.github.binarywang.wxpay.bean.order}包下的类对象
     */
//    @ApiOperation(value = "统一下单，并组装所需支付参数")
//    @PostMapping("/createOrder")
    public <T> T createOrder(WxPayUnifiedOrderRequest request) throws WxPayException {
        return this.wxService.createOrder(request);
    }


    @Test
    public void order()  {
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();

        wxPayUnifiedOrderRequest.setBody("会员充值");

        // 商户系统内部的订单号,32个字符内、可包含字母, 其他说明见商户订单号

        wxPayUnifiedOrderRequest.setOutTradeNo("00001");

        //订单总金额，单位为分，详见支付金额
        wxPayUnifiedOrderRequest.setTotalFee(1);

        // APP和网页支付提交用户端ip
        wxPayUnifiedOrderRequest.setSpbillCreateIp("111.111.222.33");

        // 接收微信支付异步通知回调地址，通知url必须为直接可访问的url，不能携带参数。
        wxPayUnifiedOrderRequest.setNotifyUrl("http");

        wxPayUnifiedOrderRequest.setOpenid("ogXcu56o2ZYi-MgLRkSklKbe-PdU");

        wxPayUnifiedOrderRequest.setTradeType("JSAPI");

        Object order=null;
        try {
            order = createOrder(wxPayUnifiedOrderRequest);
        } catch (WxPayException e) {
            e.printStackTrace();
        }

        int i =1;

    }


}
